/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.module;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.repository.module.ModuleArtifactRepository;
import org.eclipse.tycho.repository.module.ModuleMetadataRepository;

class PublishingRepositoryLoader {
    private static final Map<String, String> EMPTY_MAP = Collections.emptyMap();
    private static final String BUILD_REPOSITORY_NAME = "";
    private final IProvisioningAgent agent;
    private final ReactorProjectIdentities project;

    public PublishingRepositoryLoader(IProvisioningAgent agent, ReactorProjectIdentities project) {
        this.agent = agent;
        this.project = project;
    }

    public ModuleMetadataRepository getModuleMetadataRepository() {
        IMetadataRepositoryManager repoManager = (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.class);
        URI location = this.project.getBuildDirectory().getLocation().toURI();
        return this.getModuleMetadataRepository(repoManager, location);
    }

    private ModuleMetadataRepository getModuleMetadataRepository(IMetadataRepositoryManager repoManager, URI location) {
        try {
            return (ModuleMetadataRepository)repoManager.loadRepository(location, 1, null);
        }
        catch (ProvisionException e) {
            if (e.getStatus() != null && e.getStatus().getCode() == 1000) {
                return this.createModuleMetadataRepository(repoManager, location);
            }
            throw new RuntimeException(e);
        }
    }

    private ModuleMetadataRepository createModuleMetadataRepository(IMetadataRepositoryManager repoManager, URI location) {
        try {
            return (ModuleMetadataRepository)repoManager.createRepository(location, BUILD_REPOSITORY_NAME, "org.eclipse.tycho.repository.module.ModuleMetadataRepository", EMPTY_MAP);
        }
        catch (ProvisionException e) {
            throw new RuntimeException(e);
        }
    }

    public ModuleArtifactRepository getModuleArtifactRepository() {
        IArtifactRepositoryManager repoManager = (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.class);
        URI location = this.project.getBuildDirectory().getLocation().toURI();
        ModuleArtifactRepository moduleArtifactRepository = this.getModuleArtifactRepository(repoManager, location);
        moduleArtifactRepository.setGAV(this.project.getGroupId(), this.project.getArtifactId(), this.project.getVersion());
        return moduleArtifactRepository;
    }

    private ModuleArtifactRepository getModuleArtifactRepository(IArtifactRepositoryManager repoManager, URI location) {
        try {
            return (ModuleArtifactRepository)repoManager.loadRepository(location, 1, null);
        }
        catch (ProvisionException e) {
            if (e.getStatus() != null && e.getStatus().getCode() == 1000) {
                return this.createModuleArtifactRepository(repoManager, location);
            }
            throw new RuntimeException(e);
        }
    }

    private ModuleArtifactRepository createModuleArtifactRepository(IArtifactRepositoryManager repoManager, URI location) {
        try {
            return (ModuleArtifactRepository)repoManager.createRepository(location, BUILD_REPOSITORY_NAME, "org.eclipse.tycho.repository.module.ModuleArtifactRepository", EMPTY_MAP);
        }
        catch (ProvisionException e) {
            throw new RuntimeException(e);
        }
    }
}

