/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.local;

import java.util.Map;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.tycho.p2.repository.GAV;
import org.eclipse.tycho.p2.repository.MavenRepositoryCoordinates;
import org.eclipse.tycho.p2.repository.RepositoryLayoutHelper;
import org.eclipse.tycho.repository.util.GAVArtifactDescriptorBase;

public class GAVArtifactDescriptor
extends GAVArtifactDescriptorBase {
    public GAVArtifactDescriptor(IArtifactDescriptor p2Descriptor, MavenRepositoryCoordinates mavenCoordinates) {
        super(p2Descriptor, mavenCoordinates, true);
    }

    public GAVArtifactDescriptor(IArtifactDescriptor base) {
        super(base, GAVArtifactDescriptor.readOrDeriveMavenCoordinates(base), false);
    }

    public GAVArtifactDescriptor(IArtifactKey p2Key) {
        super(p2Key, GAVArtifactDescriptor.getP2DerivedCoordinates(p2Key, null), false);
    }

    private static MavenRepositoryCoordinates getP2DerivedCoordinates(IArtifactKey key, Map<String, String> properties) {
        GAV gav = RepositoryLayoutHelper.getP2Gav((String)key.getClassifier(), (String)key.getId(), (String)key.getVersion().toString());
        String classifier = null;
        String extension = "jar";
        if (properties != null && "packed".equals(properties.get("format"))) {
            classifier = "pack200";
            extension = "jar.pack.gz";
        }
        return new MavenRepositoryCoordinates(gav, classifier, extension);
    }

    private static MavenRepositoryCoordinates readOrDeriveMavenCoordinates(IArtifactDescriptor base) {
        MavenRepositoryCoordinates result = GAVArtifactDescriptor.readMavenCoordinateProperties(base);
        if (result == null) {
            result = GAVArtifactDescriptor.getP2DerivedCoordinates(base.getArtifactKey(), base.getProperties());
        }
        return result;
    }
}

