/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.resolver;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.ArtifactDescriptor;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.artifacts.DependencyArtifacts;
import org.eclipse.tycho.artifacts.TargetPlatform;
import org.eclipse.tycho.core.ArtifactDependencyVisitor;
import org.eclipse.tycho.core.DependencyResolver;
import org.eclipse.tycho.core.DependencyResolverConfiguration;
import org.eclipse.tycho.core.FeatureDescription;
import org.eclipse.tycho.core.PluginDescription;
import org.eclipse.tycho.core.TargetPlatformConfiguration;
import org.eclipse.tycho.core.TychoConstants;
import org.eclipse.tycho.core.TychoProject;
import org.eclipse.tycho.core.ee.ExecutionEnvironmentConfigurationImpl;
import org.eclipse.tycho.core.osgitools.AbstractTychoProject;
import org.eclipse.tycho.core.osgitools.DebugUtils;
import org.eclipse.tycho.core.resolver.DefaultDependencyResolverFactory;
import org.eclipse.tycho.core.resolver.DefaultTargetPlatformConfigurationReader;
import org.eclipse.tycho.core.resolver.shared.PlatformPropertiesUtils;
import org.eclipse.tycho.core.utils.TychoProjectUtils;
import org.eclipse.tycho.resolver.DependencyVisitor;
import org.eclipse.tycho.resolver.TychoResolver;

@Component(role=TychoResolver.class)
public class DefaultTychoResolver
implements TychoResolver {
    @Requirement
    private Logger logger;
    @Requirement
    private DefaultTargetPlatformConfigurationReader configurationReader;
    @Requirement
    private DefaultDependencyResolverFactory dependencyResolverLocator;
    @Requirement(role=TychoProject.class)
    private Map<String, TychoProject> projectTypes;
    public static final String TYCHO_ENV_OSGI_WS = "tycho.env.osgi.ws";
    public static final String TYCHO_ENV_OSGI_OS = "tycho.env.osgi.os";
    public static final String TYCHO_ENV_OSGI_ARCH = "tycho.env.osgi.arch";

    public void setupProject(MavenSession session, MavenProject project, ReactorProject reactorProject) {
        AbstractTychoProject dr = (AbstractTychoProject)this.projectTypes.get(project.getPackaging());
        if (dr == null) {
            return;
        }
        if (project.getContextValue(TychoConstants.CTX_MERGED_PROPERTIES) != null) {
            return;
        }
        dr.setupProject(session, project);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)project.getProperties());
        properties.putAll((Map<?, ?>)session.getSystemProperties());
        properties.putAll((Map<?, ?>)session.getUserProperties());
        project.setContextValue(TychoConstants.CTX_MERGED_PROPERTIES, (Object)properties);
        this.setTychoEnvironmentProperties(properties, project);
        TargetPlatformConfiguration configuration = this.configurationReader.getTargetPlatformConfiguration(session, project);
        project.setContextValue(TychoConstants.CTX_TARGET_PLATFORM_CONFIGURATION, (Object)configuration);
        ExecutionEnvironmentConfigurationImpl eeConfiguration = new ExecutionEnvironmentConfigurationImpl(this.logger, !configuration.isResolveWithEEConstraints());
        dr.readExecutionEnvironmentConfiguration(project, eeConfiguration);
        project.setContextValue(TychoConstants.CTX_EXECUTION_ENVIRONMENT_CONFIGURATION, (Object)eeConfiguration);
        DependencyResolver resolver = this.dependencyResolverLocator.lookupDependencyResolver(project);
        resolver.setupProjects(session, project, reactorProject);
    }

    public void resolveProject(MavenSession session, MavenProject project, List<ReactorProject> reactorProjects) {
        StringBuilder sb;
        AbstractTychoProject dr = (AbstractTychoProject)this.projectTypes.get(project.getPackaging());
        if (dr == null) {
            return;
        }
        DependencyResolver resolver = this.dependencyResolverLocator.lookupDependencyResolver(project);
        this.logger.info("Computing target platform for " + project);
        TargetPlatform preliminaryTargetPlatform = resolver.computePreliminaryTargetPlatform(session, project, reactorProjects);
        TargetPlatformConfiguration configuration = TychoProjectUtils.getTargetPlatformConfiguration(project);
        DependencyResolverConfiguration resolverConfiguration = configuration.getDependencyResolverConfiguration();
        this.logger.info("Resolving dependencies of " + project);
        DependencyArtifacts dependencyArtifacts = resolver.resolveDependencies(session, project, preliminaryTargetPlatform, reactorProjects, resolverConfiguration);
        if (this.logger.isDebugEnabled() && DebugUtils.isDebugEnabled(session, project)) {
            sb = new StringBuilder();
            sb.append("Resolved target platform for ").append(project).append("\n");
            dependencyArtifacts.toDebugString(sb, "  ");
            this.logger.debug(sb.toString());
        }
        dr.setDependencyArtifacts(session, project, dependencyArtifacts);
        this.logger.info("Resolving class path of " + project);
        dr.resolveClassPath(session, project);
        resolver.injectDependenciesIntoMavenModel(project, dr, dependencyArtifacts, this.logger);
        if (this.logger.isDebugEnabled() && DebugUtils.isDebugEnabled(session, project)) {
            sb = new StringBuilder();
            sb.append("Injected dependencies for ").append(project.toString()).append("\n");
            for (Dependency dependency : project.getDependencies()) {
                sb.append("  ").append(dependency.toString());
            }
            this.logger.debug(sb.toString());
        }
    }

    public void traverse(MavenProject project, final DependencyVisitor visitor) {
        TychoProject tychoProject = this.projectTypes.get(project.getPackaging());
        if (tychoProject != null) {
            tychoProject.getDependencyWalker(project).walk(new ArtifactDependencyVisitor(){

                @Override
                public void visitPlugin(PluginDescription plugin) {
                    visitor.visit((ArtifactDescriptor)plugin);
                }

                @Override
                public boolean visitFeature(FeatureDescription feature) {
                    return visitor.visit((ArtifactDescriptor)feature);
                }
            });
        }
    }

    protected void setTychoEnvironmentProperties(Properties properties, MavenProject project) {
        String arch = PlatformPropertiesUtils.getArch((Properties)properties);
        String os = PlatformPropertiesUtils.getOS((Properties)properties);
        String ws = PlatformPropertiesUtils.getWS((Properties)properties);
        project.getProperties().put(TYCHO_ENV_OSGI_WS, ws);
        project.getProperties().put(TYCHO_ENV_OSGI_OS, os);
        project.getProperties().put(TYCHO_ENV_OSGI_ARCH, arch);
    }
}

