/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.osgi.configuration;

import java.net.URI;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.plugin.LegacySupport;
import org.apache.maven.repository.MirrorSelector;
import org.apache.maven.repository.RepositorySystem;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.crypto.SettingsDecryptionResult;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.sisu.equinox.embedder.EmbeddedEquinox;
import org.eclipse.sisu.equinox.embedder.EquinoxLifecycleListener;
import org.eclipse.tycho.core.resolver.shared.MavenRepositoryLocation;
import org.eclipse.tycho.core.resolver.shared.MavenRepositorySettings;
import org.eclipse.tycho.osgi.configuration.SettingsDecrypterHelper;

@Component(role=EquinoxLifecycleListener.class, hint="RepositorySettingsConfigurator")
public class RepositorySettingsConfigurator
extends EquinoxLifecycleListener {
    private static final ArtifactRepositoryPolicy P2_REPOSITORY_POLICY = new ArtifactRepositoryPolicy(true, "never", "ignore");
    @Requirement
    private Logger logger;
    @Requirement
    private LegacySupport context;
    @Requirement
    private SettingsDecrypterHelper decrypter;
    @Requirement
    private RepositorySystem repositorySystem;
    @Requirement(hint="p2")
    private ArtifactRepositoryLayout p2layout;
    @Requirement(role=MirrorSelector.class, hint="tycho")
    private MirrorSelector mirrorSelector;

    public void afterFrameworkStarted(EmbeddedEquinox framework) {
        framework.registerService(MavenRepositorySettings.class, (Object)new MavenRepositorySettingsProvider());
    }

    private class MavenRepositorySettingsProvider
    implements MavenRepositorySettings {
        private MavenRepositorySettingsProvider() {
        }

        public MavenRepositoryLocation getMirror(MavenRepositoryLocation location) {
            if (location.getId() == null) {
                return null;
            }
            ArtifactRepository locationAsMavenRepository = RepositorySettingsConfigurator.this.repositorySystem.createArtifactRepository(location.getId(), location.getURL().toString(), RepositorySettingsConfigurator.this.p2layout, P2_REPOSITORY_POLICY, P2_REPOSITORY_POLICY);
            Mirror mirror = RepositorySettingsConfigurator.this.mirrorSelector.getMirror(locationAsMavenRepository, RepositorySettingsConfigurator.this.context.getSession().getRequest().getMirrors());
            if (mirror != null) {
                return new MavenRepositoryLocation(mirror.getId(), URI.create(mirror.getUrl()));
            }
            return null;
        }

        public MavenRepositorySettings.Credentials getCredentials(MavenRepositoryLocation location) {
            if (location.getId() == null) {
                return null;
            }
            Server serverSettings = RepositorySettingsConfigurator.this.context.getSession().getSettings().getServer(location.getId());
            if (serverSettings != null) {
                SettingsDecryptionResult result = RepositorySettingsConfigurator.this.decrypter.decryptAndLogProblems(serverSettings);
                Server decryptedServer = result.getServer();
                return new MavenRepositorySettings.Credentials(decryptedServer.getUsername(), decryptedServer.getPassword());
            }
            return null;
        }
    }
}

