/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.resolver;

import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.repository.DefaultMirrorSelector;
import org.apache.maven.repository.MirrorSelector;
import org.apache.maven.settings.Mirror;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;

@Component(role=MirrorSelector.class, hint="tycho")
public class TychoMirrorSelector
extends DefaultMirrorSelector {
    public Mirror getMirror(ArtifactRepository repository, List<Mirror> mirrors) {
        Mirror mavenMirror = super.getMirror(repository, mirrors);
        if (mavenMirror != null || mirrors == null) {
            return mavenMirror;
        }
        for (Mirror mirror : mirrors) {
            if (!this.isPrefixMirrorOf(repository, mirror)) continue;
            return this.createMirror(repository, mirror);
        }
        return null;
    }

    private boolean isPrefixMirrorOf(ArtifactRepository repo, Mirror mirror) {
        boolean isMirrorOfRepoUrl = repo.getUrl() != null && repo.getUrl().startsWith(mirror.getMirrorOf());
        boolean matchesLayout = repo.getLayout() != null && repo.getLayout().getId().equals(mirror.getMirrorOfLayouts());
        return isMirrorOfRepoUrl && matchesLayout;
    }

    private Mirror createMirror(ArtifactRepository repo, Mirror toMirror) {
        Mirror mirror = toMirror.clone();
        String urlToReplace = toMirror.getMirrorOf();
        String newUrl = StringUtils.replaceOnce((String)repo.getUrl(), (String)urlToReplace, (String)toMirror.getUrl());
        mirror.setUrl(newUrl);
        mirror.setId(toMirror.getId());
        return mirror;
    }
}

