/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.input.awt;

import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jemmy.JemmyException;
import org.jemmy.interfaces.Keyboard;
import org.jemmy.interfaces.Modifier;
import org.jemmy.interfaces.Mouse;

public class AWTMap {
    private static Map<Integer, Keyboard.KeyboardButton> int2key;
    private static Map<Integer, Modifier> int2modifier;
    private static Map<Integer, Mouse.MouseButton> int2button;
    private static Map<Keyboard.KeyboardButton, Integer> key2int;
    private static Map<Modifier, Integer> modifier2int;
    private static Map<Mouse.MouseButton, Integer> button2int;

    public int convert(Keyboard.KeyboardButton button) {
        try {
            return key2int.get(button);
        }
        catch (Exception e) {
            throw new JemmyException("Unable to recognize key", (Throwable)e, (Object)button);
        }
    }

    public int convert(Modifier ... modifiers) {
        int result = 0;
        for (Modifier modifier : modifiers) {
            try {
                result |= modifier2int.get(modifier).intValue();
            }
            catch (Exception e) {
                throw new JemmyException("Unable to recognize modifier", (Throwable)e, (Object)modifier);
            }
        }
        return result;
    }

    public int convert(Mouse.MouseButton button) {
        try {
            return button2int.get(button);
        }
        catch (Exception e) {
            throw new JemmyException("Unable to recognize mouse button", (Throwable)e, (Object)button);
        }
    }

    public Keyboard.KeyboardButton convertKeyboardButton(int key) {
        Keyboard.KeyboardButton res = int2key.get(key);
        if (res == null) {
            throw new JemmyException("Unable to recognize key", (Object)key);
        }
        return res;
    }

    public Modifier[] convertModifiers(int modifiers) {
        ArrayList<Modifier> result = new ArrayList<Modifier>();
        for (int key : int2modifier.keySet()) {
            if ((key & modifiers) == 0) continue;
            Modifier res = int2modifier.get(key);
            if (res == null) {
                throw new JemmyException("Unable to recognize modifiers", (Object)modifiers);
            }
            result.add(res);
        }
        return result.toArray(new Modifier[result.size()]);
    }

    public Mouse.MouseButton convertMouseButton(int button) {
        Mouse.MouseButton res = int2button.get(button);
        if (res == null) {
            throw new JemmyException("Unable to recognize mouse button", (Object)button);
        }
        return res;
    }

    static {
        int key;
        String name;
        int2key = new HashMap<Integer, Keyboard.KeyboardButton>();
        int2modifier = new HashMap<Integer, Modifier>();
        int2button = new HashMap<Integer, Mouse.MouseButton>();
        key2int = new HashMap<Keyboard.KeyboardButton, Integer>();
        modifier2int = new HashMap<Modifier, Integer>();
        button2int = new HashMap<Mouse.MouseButton, Integer>();
        for (Keyboard.KeyboardButtons keyboardButtons : Keyboard.KeyboardButtons.values()) {
            name = keyboardButtons.name();
            try {
                key = 0;
                key = name.length() == 2 && name.startsWith("D") ? KeyEvent.class.getDeclaredField("VK_" + name.substring(1)).getInt(null) : KeyEvent.class.getDeclaredField("VK_" + name).getInt(null);
                int2key.put(key, (Keyboard.KeyboardButton)keyboardButtons);
                key2int.put((Keyboard.KeyboardButton)keyboardButtons, key);
            }
            catch (NoSuchFieldException ex) {
                throw new JemmyException("Unable to recognize key", (Throwable)ex, (Object)keyboardButtons);
            }
            catch (SecurityException ex) {
                throw new JemmyException("Unable to recognize key", (Throwable)ex, (Object)keyboardButtons);
            }
            catch (IllegalArgumentException ex) {
                throw new JemmyException("Unable to recognize key", (Throwable)ex, (Object)keyboardButtons);
            }
            catch (IllegalAccessException ex) {
                throw new JemmyException("Unable to recognize key", (Throwable)ex, (Object)keyboardButtons);
            }
        }
        for (Keyboard.KeyboardButtons keyboardButtons : Keyboard.KeyboardModifiers.values()) {
            name = keyboardButtons.name();
            try {
                key = InputEvent.class.getDeclaredField(name).getInt(null);
                int2modifier.put(key, (Modifier)keyboardButtons);
                modifier2int.put((Modifier)keyboardButtons, key);
            }
            catch (NoSuchFieldException ex) {
                throw new JemmyException("Unable to recognize modifier", (Throwable)ex, (Object)keyboardButtons);
            }
            catch (SecurityException ex) {
                throw new JemmyException("Unable to recognize modifier", (Throwable)ex, (Object)keyboardButtons);
            }
            catch (IllegalArgumentException ex) {
                throw new JemmyException("Unable to recognize modifier", (Throwable)ex, (Object)keyboardButtons);
            }
            catch (IllegalAccessException ex) {
                throw new JemmyException("Unable to recognize modifier", (Throwable)ex, (Object)keyboardButtons);
            }
        }
        for (Keyboard.KeyboardButtons keyboardButtons : Mouse.MouseModifiers.values()) {
            name = keyboardButtons.name();
            try {
                key = InputEvent.class.getDeclaredField(name).getInt(null);
                int2modifier.put(key, (Modifier)keyboardButtons);
                modifier2int.put((Modifier)keyboardButtons, key);
            }
            catch (NoSuchFieldException ex) {
                throw new JemmyException("Unable to recognize modifier", (Throwable)ex, (Object)keyboardButtons);
            }
            catch (SecurityException ex) {
                throw new JemmyException("Unable to recognize modifier", (Throwable)ex, (Object)keyboardButtons);
            }
            catch (IllegalArgumentException ex) {
                throw new JemmyException("Unable to recognize modifier", (Throwable)ex, (Object)keyboardButtons);
            }
            catch (IllegalAccessException ex) {
                throw new JemmyException("Unable to recognize modifier", (Throwable)ex, (Object)keyboardButtons);
            }
        }
        for (Keyboard.KeyboardButtons keyboardButtons : Mouse.MouseButtons.values()) {
            name = keyboardButtons.name();
            try {
                key = InputEvent.class.getDeclaredField(name + "_MASK").getInt(null);
                int2button.put(key, (Mouse.MouseButton)keyboardButtons);
                button2int.put((Mouse.MouseButton)keyboardButtons, key);
            }
            catch (NoSuchFieldException ex) {
                throw new JemmyException("Unable to recognize button", (Throwable)ex, (Object)keyboardButtons);
            }
            catch (SecurityException ex) {
                throw new JemmyException("Unable to recognize button", (Throwable)ex, (Object)keyboardButtons);
            }
            catch (IllegalArgumentException ex) {
                throw new JemmyException("Unable to recognize button", (Throwable)ex, (Object)keyboardButtons);
            }
            catch (IllegalAccessException ex) {
                throw new JemmyException("Unable to recognize button", (Throwable)ex, (Object)keyboardButtons);
            }
        }
    }
}

