/*
 * Decompiled with CFR 0.152.
 */
package org.jemmy.image.pixel;

import org.jemmy.Dimension;
import org.jemmy.image.pixel.PixelImageComparator;
import org.jemmy.image.pixel.Raster;
import org.jemmy.image.pixel.ThresholdComparator;

public abstract class BaseCountingRasterComparator
extends ThresholdComparator {
    public BaseCountingRasterComparator(double threshold) {
        super(0.0, 1.0);
        this.setThreshold(threshold);
    }

    @Override
    public boolean compare(Raster image1, Raster image2) {
        Dimension size = PixelImageComparator.computeDiffSize(image1, image2);
        if (size == null) {
            return false;
        }
        int totalPixels = size.width * size.height;
        int offPixels = 0;
        double[] colors1 = new double[image1.getSupported().length];
        double[] colors2 = new double[image2.getSupported().length];
        for (int x = 0; x < size.width; ++x) {
            for (int y = 0; y < size.height; ++y) {
                image1.getColors(x, y, colors1);
                image2.getColors(x, y, colors2);
                if (this.compare(image1.getSupported(), colors1, image2.getSupported(), colors2)) continue;
                ++offPixels;
            }
        }
        return (double)offPixels <= (double)totalPixels * this.getThreshold();
    }

    protected abstract boolean compare(Raster.Component[] var1, double[] var2, Raster.Component[] var3, double[] var4);
}

