/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.p2;

import java.util.Collection;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.ArtifactDownload;
import org.eclipse.aether.spi.connector.ArtifactUpload;
import org.eclipse.aether.spi.connector.MetadataDownload;
import org.eclipse.aether.spi.connector.MetadataUpload;
import org.eclipse.aether.spi.connector.RepositoryConnector;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.MetadataNotFoundException;
import org.eclipse.aether.transfer.MetadataTransferException;

public class P2RepositoryConnector
implements RepositoryConnector {
    private final RemoteRepository repository;

    public P2RepositoryConnector(RemoteRepository repository) {
        this.repository = repository;
    }

    public void get(Collection<? extends ArtifactDownload> artifactDownloads, Collection<? extends MetadataDownload> metadataDownloads) {
        if (artifactDownloads != null) {
            for (ArtifactDownload artifactDownload : artifactDownloads) {
                artifactDownload.setException((ArtifactTransferException)new ArtifactNotFoundException(artifactDownload.getArtifact(), this.repository));
            }
        }
        if (metadataDownloads != null) {
            for (MetadataDownload metadataDownload : metadataDownloads) {
                metadataDownload.setException((MetadataTransferException)new MetadataNotFoundException(metadataDownload.getMetadata(), this.repository));
            }
        }
    }

    public void put(Collection<? extends ArtifactUpload> artifactUploads, Collection<? extends MetadataUpload> metadataUploads) {
        if (artifactUploads != null) {
            for (ArtifactUpload artifactUpload : artifactUploads) {
                artifactUpload.setException((ArtifactTransferException)new ArtifactNotFoundException(artifactUpload.getArtifact(), this.repository));
            }
        }
        if (metadataUploads != null) {
            for (MetadataUpload metadataUpload : metadataUploads) {
                metadataUpload.setException((MetadataTransferException)new MetadataNotFoundException(metadataUpload.getMetadata(), this.repository));
            }
        }
    }

    public void close() {
    }
}

