/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.osgitools;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.tycho.classpath.ClasspathEntry;
import org.eclipse.tycho.core.osgitools.DefaultClasspathEntry;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.resource.Capability;

@Component(role=DependencyComputer.class)
public class DependencyComputer {
    public List<DependencyEntry> computeDependencies(ModuleRevision module) {
        if (module == null) {
            return Collections.emptyList();
        }
        VisiblePackages visiblePackages = this.getPackagesInternal(module);
        HashSet<ModuleRevision> added = new HashSet<ModuleRevision>();
        added.add(module);
        LinkedHashSet<DependencyEntry> entries = new LinkedHashSet<DependencyEntry>();
        DependencyComputer.getFragmentHost(module).ifPresent(host -> this.addHostPlugin((ModuleRevision)host, (Set<ModuleRevision>)added, visiblePackages, (Set<DependencyEntry>)entries));
        this.getRequiredBundles(module).forEach(required -> this.addDependency((ModuleRevision)required, (Collection<ModuleRevision>)added, visiblePackages, (Set<DependencyEntry>)entries));
        TreeMap<String, ModuleRevision> resolvedImportPackages = new TreeMap<String, ModuleRevision>();
        for (ModuleRevision bundle : visiblePackages.getParticipatingModules()) {
            resolvedImportPackages.put(bundle.getSymbolicName(), bundle);
        }
        for (ModuleRevision bundle : resolvedImportPackages.values()) {
            this.addDependencyViaImportPackage(bundle, added, visiblePackages, entries);
        }
        return new ArrayList<DependencyEntry>(entries);
    }

    private Collection<ModuleRevision> getRequiredBundles(ModuleRevision module) {
        if (module == null) {
            return Collections.emptyList();
        }
        return module.getWiring().getRequiredModuleWires("osgi.wiring.bundle").stream().map(ModuleWire::getProvider).collect(Collectors.toList());
    }

    private static Optional<ModuleRevision> getFragmentHost(ModuleRevision bundleRevision) {
        return bundleRevision.getWiring().getRequiredModuleWires("osgi.wiring.host").stream().map(ModuleWire::getProvider).findAny();
    }

    private VisiblePackages getPackagesInternal(ModuleRevision module) {
        Map<String, Set<ModuleCapability>> sources = this.getPackagesInternal0(module.getWiring(), new HashMap<ModuleWiring, Map<String, Set<ModuleCapability>>>());
        VisiblePackages res = new VisiblePackages(module);
        sources.values().stream().flatMap(Collection::stream).forEach(res::add);
        return res;
    }

    private Map<String, Set<ModuleCapability>> getPackagesInternal0(ModuleWiring wiring, Map<ModuleWiring, Map<String, Set<ModuleCapability>>> allSources) {
        Map<String, Set<ModuleCapability>> packages = allSources.get(wiring);
        if (packages != null) {
            return packages;
        }
        packages = new TreeMap<String, Set<ModuleCapability>>();
        allSources.put(wiring, packages);
        HashSet<String> importedPackageNames = new HashSet<String>();
        this.populateFromWiring(wiring, allSources, packages, importedPackageNames);
        for (ModuleWire fragmentWire : wiring.getRequiredModuleWires("osgi.wiring.host")) {
            this.populateFromWiring(fragmentWire.getProviderWiring(), allSources, packages, importedPackageNames);
        }
        return packages;
    }

    private void populateFromWiring(ModuleWiring wiring, Map<ModuleWiring, Map<String, Set<ModuleCapability>>> allSources, Map<String, Set<ModuleCapability>> packages, Set<String> importedPackageNames) {
        for (ModuleWire packageWire : wiring.getRequiredModuleWires("osgi.wiring.package")) {
            String packageName = DependencyComputer.getPackageName((Capability)packageWire.getCapability());
            importedPackageNames.add(packageName);
            this.addAggregatePackageSource(packageWire.getCapability(), packageName, packageWire, packages, allSources);
        }
        for (ModuleWire requiredWire : this.getRequiredAndAllAccessibleModuleWires(wiring)) {
            this.getRequiredBundlePackages(requiredWire, importedPackageNames, packages, allSources);
        }
    }

    private Collection<ModuleWire> getRequiredAndAllAccessibleModuleWires(ModuleWiring wiring) {
        LinkedHashSet<ModuleWire> requiredAndReexportedWires = new LinkedHashSet<ModuleWire>();
        LinkedList<ModuleWire> toVisitWires = new LinkedList<ModuleWire>();
        toVisitWires.addAll(wiring.getRequiredModuleWires("osgi.wiring.bundle"));
        while (!toVisitWires.isEmpty()) {
            ModuleWire moduleWire = (ModuleWire)toVisitWires.removeFirst();
            if (!requiredAndReexportedWires.add(moduleWire)) continue;
            ModuleWiring providerWiring = moduleWire.getProviderWiring();
            toVisitWires.addAll(this.getRequiredModuleWiresWithVisibilityReexport(providerWiring));
        }
        return requiredAndReexportedWires;
    }

    private Collection<ModuleWire> getRequiredModuleWiresWithVisibilityReexport(ModuleWiring wiring) {
        return wiring.getRequiredModuleWires("osgi.wiring.bundle").stream().filter(DependencyComputer::hasVisibilityReexport).collect(Collectors.toList());
    }

    private void addAggregatePackageSource(ModuleCapability packageCap, String packageName, ModuleWire wire, Map<String, Set<ModuleCapability>> packages, Map<ModuleWiring, Map<String, Set<ModuleCapability>>> allSources) {
        Set packageSources = packages.computeIfAbsent(packageName, p -> new LinkedHashSet());
        packageSources.add(packageCap);
        for (ModuleWire fragmentWire : packageCap.getResource().getWiring().getProvidedModuleWires("osgi.wiring.host")) {
            for (ModuleCapability fragmentExport : fragmentWire.getRequirer().getModuleCapabilities("osgi.wiring.package")) {
                if (!DependencyComputer.getPackageName((Capability)fragmentExport).equals(DependencyComputer.getPackageName((Capability)packageCap))) continue;
                packageSources.add(fragmentExport);
            }
        }
        Set<ModuleCapability> providerSource = this.getPackagesInternal0(wire.getProviderWiring(), allSources).get(packageName);
        if (providerSource != null) {
            packageSources.addAll(providerSource);
        }
    }

    private void getRequiredBundlePackages(ModuleWire requiredWire, Set<String> importedPackageNames, Map<String, Set<ModuleCapability>> packages, Map<ModuleWiring, Map<String, Set<ModuleCapability>>> allSources) {
        ModuleWiring providerWiring = requiredWire.getProviderWiring();
        for (ModuleCapability packageCapability : providerWiring.getModuleCapabilities("osgi.wiring.package")) {
            String packageName = DependencyComputer.getPackageName((Capability)packageCapability);
            if (importedPackageNames.contains(packageName)) continue;
            this.addAggregatePackageSource(packageCapability, packageName, requiredWire, packages, allSources);
        }
        HashSet<String> declaredPackageNames = new HashSet<String>();
        for (BundleCapability declaredPackage : providerWiring.getRevision().getDeclaredCapabilities("osgi.wiring.package")) {
            declaredPackageNames.add(DependencyComputer.getPackageName((Capability)declaredPackage));
        }
        for (BundleWire fragmentWire : providerWiring.getProvidedWires("osgi.wiring.host")) {
            for (BundleCapability declaredPackage : fragmentWire.getRequirer().getDeclaredCapabilities("osgi.wiring.package")) {
                declaredPackageNames.add(DependencyComputer.getPackageName((Capability)declaredPackage));
            }
        }
        for (ModuleWire packageWire : providerWiring.getRequiredModuleWires("osgi.wiring.package")) {
            String packageName = DependencyComputer.getPackageName((Capability)packageWire.getCapability());
            if (importedPackageNames.contains(packageName) || !declaredPackageNames.contains(packageName)) continue;
            this.addAggregatePackageSource(packageWire.getCapability(), packageName, packageWire, packages, allSources);
        }
    }

    private static ClasspathEntry.AccessRule createRule(ModuleRevision consumer, Capability export) {
        String name = DependencyComputer.getPackageName(export);
        String path = name.equals(".") ? "*" : name.replace('.', '/') + "/*";
        return new DefaultClasspathEntry.DefaultAccessRule(path, DependencyComputer.isDiscouragedAccess((BundleRevision)consumer, export));
    }

    private static String getPackageName(Capability capability) {
        return (String)capability.getAttributes().get("osgi.wiring.package");
    }

    private void addDependencyViaImportPackage(ModuleRevision module, Collection<ModuleRevision> added, VisiblePackages visiblePackages, Set<DependencyEntry> entries) {
        if (module == null || !added.add(module)) {
            return;
        }
        this.addPlugin(module, true, visiblePackages, entries);
        for (ModuleRevision fragment : this.getFragments(module)) {
            this.addDependencyViaImportPackage(fragment, added, visiblePackages, entries);
        }
    }

    private Collection<ModuleRevision> getFragments(ModuleRevision host) {
        if (host == null) {
            return Collections.emptyList();
        }
        return host.getWiring().getProvidedModuleWires("osgi.wiring.host").stream().map(ModuleWire::getRequirer).collect(Collectors.toList());
    }

    private void addDependency(ModuleRevision desc, Collection<ModuleRevision> added, VisiblePackages visiblePackages, Set<DependencyEntry> entries) {
        this.addDependency(desc, added, visiblePackages, entries, true);
    }

    private void addDependency(ModuleRevision desc, Collection<ModuleRevision> added, VisiblePackages visiblePackages, Set<DependencyEntry> entries, boolean useInclusion) {
        if (desc == null || !added.add(desc)) {
            return;
        }
        this.addPlugin(desc, useInclusion, visiblePackages, entries);
        for (ModuleRevision fragment : this.getFragments(desc)) {
            this.addDependency(fragment, added, visiblePackages, entries, useInclusion);
        }
        for (ModuleRevision required : this.getRequiredBundles(desc)) {
            this.addDependency(required, added, visiblePackages, entries, useInclusion);
        }
    }

    private void addPlugin(ModuleRevision module, boolean useInclusions, VisiblePackages visiblePackages, Set<DependencyEntry> entries) {
        Collection<ClasspathEntry.AccessRule> rules = useInclusions ? visiblePackages.getInclusions(module) : null;
        DependencyEntry entry = new DependencyEntry(module, rules);
        entries.add(entry);
    }

    private void addHostPlugin(ModuleRevision host, Set<ModuleRevision> added, VisiblePackages visiblePackages, Set<DependencyEntry> entries) {
        if (host == null) {
            return;
        }
        if (added.add(host)) {
            this.addPlugin(host, false, visiblePackages, entries);
            for (ModuleRevision required : this.getRequiredBundles(host)) {
                this.addDependency(required, added, visiblePackages, entries);
            }
            host.getWiring().getRequiredModuleWires("osgi.wiring.package").stream().map(ModuleWire::getProvider).forEach(provider -> this.addDependencyViaImportPackage((ModuleRevision)provider, (Collection<ModuleRevision>)added, visiblePackages, entries));
        }
    }

    public List<ClasspathEntry.AccessRule> computeBootClasspathExtraAccessRules(ModuleContainer container) {
        ModuleRevision systemBundle = container.getModule(0L).getCurrentRevision();
        return systemBundle.getWiring().getProvidedModuleWires("osgi.wiring.host").stream().map(ModuleWire::getRequirer).flatMap(systemFragment -> systemFragment.getDeclaredCapabilities("osgi.wiring.package").stream()).map(packageExport -> DependencyComputer.createRule(systemBundle, (Capability)packageExport)).collect(Collectors.toList());
    }

    private static boolean isDiscouragedAccess(BundleRevision bundle, Capability export) {
        if (Boolean.parseBoolean((String)export.getDirectives().get("x-internal"))) {
            return true;
        }
        String allFriends = (String)export.getDirectives().get("x-friends");
        if (allFriends != null) {
            return Arrays.stream(allFriends.split(",")).map(String::trim).noneMatch(bundle.getSymbolicName()::equals);
        }
        return false;
    }

    private static boolean hasVisibilityReexport(ModuleWire moduleWire) {
        String visibilityDirective = (String)moduleWire.getRequirement().getDirectives().get("visibility");
        return "reexport".equals(visibilityDirective);
    }

    private final class VisiblePackages {
        private final Map<ModuleRevision, Set<ClasspathEntry.AccessRule>> visiblePackages = new HashMap<ModuleRevision, Set<ClasspathEntry.AccessRule>>();
        private final ModuleRevision consumerHost;

        public VisiblePackages(ModuleRevision consumer) {
            this.consumerHost = DependencyComputer.getFragmentHost(consumer).orElse(consumer);
        }

        public void add(ModuleCapability packageCapability) {
            ClasspathEntry.AccessRule rule = DependencyComputer.createRule(this.consumerHost, (Capability)packageCapability);
            this.visiblePackages.computeIfAbsent(packageCapability.getResource(), m -> new LinkedHashSet()).add(rule);
        }

        public Collection<ClasspathEntry.AccessRule> getInclusions(ModuleRevision module) {
            Set rules = this.visiblePackages.getOrDefault(module, Collections.emptySet());
            Optional<ModuleRevision> host = DependencyComputer.getFragmentHost(module);
            if (host.isPresent()) {
                Set hostRules = this.visiblePackages.getOrDefault(host.get(), Collections.emptySet());
                rules = new HashSet(rules);
                rules.addAll(hostRules);
            }
            return Collections.unmodifiableSet(rules);
        }

        public Collection<ModuleRevision> getParticipatingModules() {
            return Collections.unmodifiableSet(this.visiblePackages.keySet());
        }
    }

    public static class DependencyEntry {
        public final ModuleRevision module;
        public final Collection<ClasspathEntry.AccessRule> rules;

        public DependencyEntry(ModuleRevision module, Collection<ClasspathEntry.AccessRule> rules) {
            this.module = module;
            this.rules = rules;
        }

        public int hashCode() {
            return Objects.hash(this.module, this.rules);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DependencyEntry other = (DependencyEntry)obj;
            return Objects.equals(this.module, other.module) && Objects.equals(this.rules, other.rules);
        }
    }
}

