/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.maven.AbstractMavenLifecycleParticipant;
import org.apache.maven.MavenExecutionException;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.eclipse.sisu.equinox.EquinoxServiceFactory;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.artifacts.DependencyResolutionException;
import org.eclipse.tycho.core.osgitools.BundleReader;
import org.eclipse.tycho.core.osgitools.DefaultBundleReader;
import org.eclipse.tycho.core.osgitools.DefaultReactorProject;
import org.eclipse.tycho.core.shared.BuildFailureException;
import org.eclipse.tycho.core.utils.TychoVersion;
import org.eclipse.tycho.resolver.TychoResolver;

@Component(role=AbstractMavenLifecycleParticipant.class, hint="TychoMavenLifecycleListener")
public class TychoMavenLifecycleParticipant
extends AbstractMavenLifecycleParticipant {
    private static final String TYCHO_GROUPID = "org.eclipse.tycho";
    private static final Set<String> TYCHO_PLUGIN_IDS = new HashSet<String>(Arrays.asList("tycho-maven-plugin", "tycho-p2-director-plugin", "tycho-p2-plugin", "tycho-p2-publisher-plugin", "tycho-p2-repository-plugin", "tycho-packaging-plugin", "tycho-pomgenerator-plugin", "tycho-source-plugin", "tycho-surefire-plugin", "tycho-versions-plugin", "tycho-compiler-plugin"));
    private static final String P2_USER_AGENT_KEY = "p2.userAgent";
    private static final String P2_USER_AGENT_VALUE = "tycho/";
    @Requirement
    private BundleReader bundleReader;
    @Requirement
    private TychoResolver resolver;
    @Requirement
    private PlexusContainer plexus;
    @Requirement
    private Logger log;
    private static final Set<String> CLEAN_PHASES = Set.of("pre-clean", "clean", "post-clean");

    public TychoMavenLifecycleParticipant() {
    }

    protected TychoMavenLifecycleParticipant(Logger log) {
        this.log = log;
    }

    public void afterProjectsRead(MavenSession session) throws MavenExecutionException {
        try {
            if (this.disableLifecycleParticipation(session)) {
                return;
            }
            List projects = session.getProjects();
            this.validate(projects);
            System.setProperty(P2_USER_AGENT_KEY, P2_USER_AGENT_VALUE + TychoVersion.getTychoVersion());
            this.configureComponents(session);
            for (MavenProject project : projects) {
                this.resolver.setupProject(session, project, DefaultReactorProject.adapt(project));
            }
            this.resolveProjects(session, projects);
        }
        catch (BuildFailureException e) {
            throw new MavenExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    public void afterSessionEnd(MavenSession session) throws MavenExecutionException {
        if (this.plexus.hasComponent(EquinoxServiceFactory.class)) {
            try {
                EquinoxServiceFactory factory = (EquinoxServiceFactory)this.plexus.lookup(EquinoxServiceFactory.class);
                if (factory instanceof Disposable) {
                    ((Disposable)factory).dispose();
                }
            }
            catch (ComponentLookupException e) {
                throw new MavenExecutionException(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void validate(List<MavenProject> projects) throws MavenExecutionException {
        this.validateConsistentTychoVersion(projects);
        this.validateUniqueBaseDirs(projects);
    }

    private void resolveProjects(MavenSession session, List<MavenProject> projects) {
        List<ReactorProject> reactorProjects = DefaultReactorProject.adapt(session);
        MavenExecutionRequest request = session.getRequest();
        boolean failFast = "FAIL_FAST".equals(request.getReactorFailureBehavior());
        ConcurrentHashMap<MavenProject, BuildFailureException> resolutionErrors = new ConcurrentHashMap<MavenProject, BuildFailureException>();
        Consumer<MavenProject> resolveProject = project -> {
            block3: {
                if (failFast && !resolutionErrors.isEmpty()) {
                    return;
                }
                try {
                    this.resolver.resolveProject(session, project, reactorProjects);
                }
                catch (BuildFailureException e) {
                    resolutionErrors.put((MavenProject)project, e);
                    if (!failFast) break block3;
                    throw e;
                }
            }
        };
        int degreeOfConcurrency = request.getDegreeOfConcurrency();
        Predicate<MavenProject> takeWhile = Predicate.not(p -> failFast && !resolutionErrors.isEmpty());
        if (degreeOfConcurrency > 1) {
            ForkJoinPool executor = new ForkJoinPool(degreeOfConcurrency);
            Future future = executor.submit(() -> projects.parallelStream().takeWhile(takeWhile).forEach(resolveProject));
            try {
                ((ForkJoinTask)future).get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new RuntimeException("resolve dependencies failed", cause);
            }
            finally {
                executor.shutdown();
            }
        } else {
            projects.stream().takeWhile(takeWhile).forEach(resolveProject);
        }
        this.reportResolutionErrors(resolutionErrors, projects, failFast);
    }

    private void reportResolutionErrors(Map<MavenProject, BuildFailureException> resolutionErrors, List<MavenProject> projects, boolean failFast) {
        if (resolutionErrors.isEmpty()) {
            return;
        }
        if (resolutionErrors.size() == 1 || failFast) {
            throw resolutionErrors.values().iterator().next();
        }
        DependencyResolutionException exception = new DependencyResolutionException(String.format("Cannot resolve dependencies of %d/%d projects, see log for details", resolutionErrors.size(), projects.size()));
        resolutionErrors.values().forEach(arg_0 -> exception.addSuppressed(arg_0));
        resolutionErrors.forEach((project, error) -> this.log.error(project.getName() + ": " + error.getMessage()));
        throw exception;
    }

    protected void validateConsistentTychoVersion(List<MavenProject> projects) throws MavenExecutionException {
        HashMap<String, LinkedHashSet<MavenProject>> versionToProjectsMap = new HashMap<String, LinkedHashSet<MavenProject>>();
        for (MavenProject project : projects) {
            for (Plugin plugin : project.getBuild().getPlugins()) {
                String version;
                if (!TYCHO_GROUPID.equals(plugin.getGroupId()) || !TYCHO_PLUGIN_IDS.contains(plugin.getArtifactId()) || (version = plugin.getVersion()) == null) continue;
                this.log.debug("org.eclipse.tycho:" + plugin.getArtifactId() + ":" + version + " configured in " + project);
                LinkedHashSet<MavenProject> projectSet = (LinkedHashSet<MavenProject>)versionToProjectsMap.get(version);
                if (projectSet == null) {
                    projectSet = new LinkedHashSet<MavenProject>();
                    versionToProjectsMap.put(version, projectSet);
                }
                projectSet.add(project);
            }
        }
        if (versionToProjectsMap.size() > 1) {
            ArrayList versions = new ArrayList(versionToProjectsMap.keySet());
            Collections.sort(versions);
            this.log.error("Several versions of tycho plugins are configured " + versions + ":");
            for (String version : versions) {
                this.log.error(version + ":");
                for (MavenProject project : (Set)versionToProjectsMap.get(version)) {
                    this.log.error("\t" + project.toString());
                }
            }
            throw new MavenExecutionException("All tycho plugins configured in one reactor must use the same version", projects.get(0).getFile());
        }
    }

    private void validateUniqueBaseDirs(List<MavenProject> projects) throws MavenExecutionException {
        HashSet<File> baseDirs = new HashSet<File>();
        for (MavenProject project : projects) {
            File basedir = project.getBasedir();
            if (baseDirs.contains(basedir)) {
                throw new MavenExecutionException("Multiple modules within the same basedir are not supported: " + basedir, project.getFile());
            }
            baseDirs.add(basedir);
        }
    }

    private boolean disableLifecycleParticipation(MavenSession session) {
        return "maven".equals(session.getUserProperties().get("tycho.mode")) || session.getUserProperties().containsKey("m2e.version") || !session.getGoals().isEmpty() && CLEAN_PHASES.containsAll(session.getGoals());
    }

    private void configureComponents(MavenSession session) {
        File localRepository = new File(session.getLocalRepository().getBasedir());
        ((DefaultBundleReader)this.bundleReader).setLocationRepository(localRepository);
    }
}

