/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.openjdk.jmc.flightrecorder.writer.SingleFieldMap;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueBuilderImpl;
import org.openjdk.jmc.flightrecorder.writer.api.TypedValue;
import org.openjdk.jmc.flightrecorder.writer.api.TypedValueBuilder;
import org.openjdk.jmc.flightrecorder.writer.util.NonZeroHashCode;

public final class TypedValueImpl
implements TypedValue {
    private int hashcode = 0;
    private final TypeImpl type;
    private final Object value;
    private final Map<String, TypedFieldValueImpl> fields;
    private final boolean isNull;
    private final long cpIndex;

    TypedValueImpl(TypeImpl type, Object value, long cpIndex) {
        Map<String, TypedFieldValueImpl> valueMap;
        if (!type.canAccept(value)) {
            throw new IllegalArgumentException();
        }
        Map<String, TypedFieldValueImpl> map = valueMap = value instanceof Map ? (Map<String, TypedFieldValueImpl>)value : null;
        if (valueMap == null && type.isSimple()) {
            valueMap = TypedValueImpl.wrapSimpleValueField(type, value);
        }
        this.type = type;
        this.value = valueMap == null ? value : null;
        this.fields = valueMap != null ? valueMap : Collections.emptyMap();
        this.isNull = value == null;
        this.cpIndex = cpIndex;
    }

    TypedValueImpl(TypeImpl type, Consumer<TypedValueBuilder> builderCallback) {
        this(Objects.requireNonNull(type), TypedValueImpl.getFieldValues(type, Objects.requireNonNull(builderCallback)));
    }

    TypedValueImpl(TypedValueBuilder builder) {
        this((TypeImpl)builder.getType(), builder.build());
    }

    private static Map<String, TypedFieldValueImpl> getFieldValues(TypeImpl type, Consumer<TypedValueBuilder> builderCallback) {
        TypedValueBuilderImpl access = new TypedValueBuilderImpl(type);
        builderCallback.accept(access);
        return access.build();
    }

    public TypedValueImpl(TypeImpl type, Object value) {
        this(type, value, Long.MIN_VALUE);
    }

    protected TypedValueImpl(TypedValueImpl other, long cpIndex) {
        if (other.getType().isBuiltin()) {
            throw new IllegalArgumentException("Value of built-in types can not reside in constant pool");
        }
        this.type = other.type;
        this.value = other.value;
        this.fields = other.fields;
        this.isNull = other.isNull;
        this.hashcode = other.hashcode;
        this.cpIndex = cpIndex;
    }

    static TypedValueImpl ofNull(TypeImpl type) {
        if (!type.canAccept(null)) {
            throw new IllegalArgumentException();
        }
        return new TypedValueImpl(type, (Object)null);
    }

    @Override
    public TypeImpl getType() {
        return this.type;
    }

    @Override
    public Object getValue() {
        return this.type.isSimple() ? this.getFieldValues().get(0).getValue().getValue() : this.value;
    }

    @Override
    public boolean isNull() {
        return this.isNull;
    }

    public List<TypedFieldValueImpl> getFieldValues() {
        if (this.isNull) {
            throw new NullPointerException();
        }
        ArrayList<TypedFieldValueImpl> values = new ArrayList<TypedFieldValueImpl>(this.fields.size());
        for (TypedFieldImpl field : this.type.getFields()) {
            TypedFieldValueImpl value = this.fields.get(field.getName());
            if (value == null) {
                value = new TypedFieldValueImpl(field, field.getType().nullValue());
            }
            values.add(value);
        }
        return values;
    }

    long getConstantPoolIndex() {
        return this.cpIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypedValueImpl that = (TypedValueImpl)o;
        return this.isNull == that.isNull && this.type.equals(that.type) && Objects.equals(this.value, that.value) && this.fields.equals(that.fields);
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = NonZeroHashCode.hash(this.type, this.value, this.fields, this.isNull);
        }
        return this.hashcode;
    }

    public String toString() {
        return "TypedValueImpl{type=" + this.type + ", value=" + this.value + ", fields=" + this.fields + ", isNull=" + this.isNull + ", cpIndex=" + this.cpIndex + '}';
    }

    static TypedValueImpl wrapSimpleValueField(TypeImpl targetType, TypedValueImpl value) {
        if (value.getType().isBuiltin()) {
            TypedFieldImpl valueField = targetType.getFields().get(0);
            TypeImpl fieldType = valueField.getType();
            if (fieldType.canAccept(value)) {
                value = targetType.asValue(new SingleFieldMap(valueField.getName(), new TypedFieldValueImpl(valueField, value)));
            } else {
                throw new IllegalArgumentException();
            }
        }
        return value;
    }

    static Map<String, TypedFieldValueImpl> wrapSimpleValueField(TypeImpl targetType, Object value) {
        TypedFieldImpl valueField = targetType.getFields().get(0);
        TypeImpl fieldType = valueField.getType();
        if (fieldType.canAccept(value)) {
            return new SingleFieldMap(valueField.getName(), new TypedFieldValueImpl(valueField, fieldType.asValue(value)));
        }
        throw new IllegalArgumentException();
    }
}

