/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.Map;
import java.util.Objects;
import org.openjdk.jmc.flightrecorder.writer.util.NonZeroHashCode;

final class ImmutableMapEntry<K, V>
implements Map.Entry<K, V> {
    private int hashCode = 0;
    private final K key;
    private final V value;

    ImmutableMapEntry(K key, V value) {
        this.key = Objects.requireNonNull(key);
        this.value = value;
    }

    @Override
    public V setValue(V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableMapEntry that = (ImmutableMapEntry)o;
        return this.key.equals(that.key) && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = NonZeroHashCode.hash(this.key, this.value);
        }
        return this.hashCode;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.value;
    }
}

