/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.function.Consumer;
import org.openjdk.jmc.flightrecorder.writer.LEB128Writer;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

final class Chunk {
    private final LEB128Writer writer = LEB128Writer.getInstance();
    private final long startTicks = System.nanoTime();
    private final long startNanos = System.currentTimeMillis() * 1000000L;

    Chunk() {
    }

    void finish(Consumer<LEB128Writer> completer) {
        completer.accept(this.writer);
    }

    void writeTypedValue(LEB128Writer writer, TypedValueImpl value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        TypeImpl t = value.getType();
        if (t.isBuiltin()) {
            this.writeBuiltinType(writer, value);
        } else if (value.getType().hasConstantPool()) {
            writer.writeLong(value.getConstantPoolIndex());
        } else {
            this.writeFields(writer, value);
        }
    }

    private void writeFields(LEB128Writer writer, TypedValueImpl value) {
        for (TypedFieldValueImpl fieldValue : value.getFieldValues()) {
            if (fieldValue.getField().isArray()) {
                writer.writeInt(fieldValue.getValues().length);
                for (TypedValueImpl tValue : fieldValue.getValues()) {
                    this.writeTypedValue(writer, tValue);
                }
                continue;
            }
            this.writeTypedValue(writer, fieldValue.getValue());
        }
    }

    private void writeBuiltinType(LEB128Writer writer, TypedValueImpl typedValue) {
        TypeImpl type = typedValue.getType();
        Object value = typedValue.getValue();
        Types.Builtin builtin = Types.Builtin.ofType(type);
        if (builtin == null) {
            throw new IllegalArgumentException();
        }
        if (value == null && builtin != Types.Builtin.STRING) {
            return;
        }
        switch (builtin) {
            case STRING: {
                if (value == null) {
                    writer.writeByte((byte)0);
                    break;
                }
                if (((String)value).isEmpty()) {
                    writer.writeByte((byte)1);
                    break;
                }
                long idx = typedValue.getConstantPoolIndex();
                if (idx > Long.MIN_VALUE) {
                    writer.writeByte((byte)2).writeLong(idx);
                    break;
                }
                writer.writeCompactUTF((String)value);
                break;
            }
            case BYTE: {
                writer.writeByte((Byte)value);
                break;
            }
            case CHAR: {
                writer.writeChar(((Character)value).charValue());
                break;
            }
            case SHORT: {
                writer.writeShort((Short)value);
                break;
            }
            case INT: {
                writer.writeInt((Integer)value);
                break;
            }
            case LONG: {
                writer.writeLong((Long)value);
                break;
            }
            case FLOAT: {
                writer.writeFloat(((Float)value).floatValue());
                break;
            }
            case DOUBLE: {
                writer.writeDouble((Double)value);
                break;
            }
            case BOOLEAN: {
                writer.writeBoolean((Boolean)value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported built-in type " + type.getTypeName());
            }
        }
    }

    void writeEvent(TypedValueImpl event) {
        if (!"jdk.jfr.Event".equals(event.getType().getSupertype())) {
            throw new IllegalArgumentException();
        }
        LEB128Writer eventWriter = LEB128Writer.getInstance();
        eventWriter.writeLong(event.getType().getId());
        for (TypedFieldValueImpl fieldValue : event.getFieldValues()) {
            this.writeTypedValue(eventWriter, fieldValue.getValue());
        }
        this.writer.writeInt(eventWriter.length()).writeBytes(eventWriter.export());
    }

    public String toString() {
        return "Chunk [writer=" + this.writer + ", startTicks=" + this.startTicks + ", startNanos=" + this.startNanos + "]";
    }
}

