/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Type;
import org.openjdk.jmc.flightrecorder.writer.api.TypedValueBuilder;
import org.openjdk.jmc.flightrecorder.writer.util.NonZeroHashCode;

abstract class BaseType
implements TypeImpl {
    int hashcode = 0;
    private final long id;
    private final String name;
    private final String supertype;
    private final ConstantPools constantPools;
    private final TypesImpl types;
    private final AtomicReference<TypedValueImpl> nullValue = new AtomicReference();

    BaseType(long id, String name, String supertype, ConstantPools constantPools, TypesImpl types) {
        this.id = id;
        this.name = name;
        this.supertype = supertype;
        this.constantPools = constantPools;
        this.types = types;
    }

    BaseType(long id, String name, ConstantPools constantPools, TypesImpl types) {
        this(id, name, null, constantPools, types);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public TypesImpl getTypes() {
        return this.types;
    }

    @Override
    public final boolean isSimple() {
        List<TypedFieldImpl> fields = this.getFields();
        if (fields.size() == 1) {
            TypedFieldImpl field = fields.get(0);
            return field.getType().isBuiltin() && !field.isArray();
        }
        return false;
    }

    @Override
    public boolean isResolved() {
        return true;
    }

    @Override
    public final String getTypeName() {
        return this.name;
    }

    @Override
    public boolean hasConstantPool() {
        return this.constantPools != null;
    }

    @Override
    public final String getSupertype() {
        return this.supertype;
    }

    @Override
    public TypedValueImpl asValue(String value) {
        if (this.hasConstantPool()) {
            return this.constantPools.forType(this).addOrGet(value);
        }
        return new TypedValueImpl((TypeImpl)this, value);
    }

    @Override
    public TypedValueImpl asValue(byte value) {
        if (this.hasConstantPool()) {
            return this.constantPools.forType(this).addOrGet(value);
        }
        return new TypedValueImpl((TypeImpl)this, (Object)value);
    }

    @Override
    public TypedValueImpl asValue(char value) {
        if (this.hasConstantPool()) {
            return this.constantPools.forType(this).addOrGet(Character.valueOf(value));
        }
        return new TypedValueImpl((TypeImpl)this, Character.valueOf(value));
    }

    @Override
    public TypedValueImpl asValue(short value) {
        if (this.hasConstantPool()) {
            return this.constantPools.forType(this).addOrGet(value);
        }
        return new TypedValueImpl((TypeImpl)this, (Object)value);
    }

    @Override
    public TypedValueImpl asValue(int value) {
        if (this.hasConstantPool()) {
            return this.constantPools.forType(this).addOrGet(value);
        }
        return new TypedValueImpl((TypeImpl)this, (Object)value);
    }

    @Override
    public TypedValueImpl asValue(long value) {
        if (this.hasConstantPool()) {
            return this.constantPools.forType(this).addOrGet(value);
        }
        return new TypedValueImpl((TypeImpl)this, (Object)value);
    }

    @Override
    public TypedValueImpl asValue(float value) {
        if (this.hasConstantPool()) {
            return this.constantPools.forType(this).addOrGet(Float.valueOf(value));
        }
        return new TypedValueImpl((TypeImpl)this, Float.valueOf(value));
    }

    @Override
    public TypedValueImpl asValue(double value) {
        if (this.hasConstantPool()) {
            return this.constantPools.forType(this).addOrGet(value);
        }
        return new TypedValueImpl((TypeImpl)this, value);
    }

    @Override
    public TypedValueImpl asValue(boolean value) {
        if (this.hasConstantPool()) {
            return this.constantPools.forType(this).addOrGet(value);
        }
        return new TypedValueImpl((TypeImpl)this, value);
    }

    @Override
    public TypedValueImpl asValue(Consumer<TypedValueBuilder> builderCallback) {
        if (this.isBuiltin()) {
            throw new IllegalArgumentException();
        }
        TypedValueImpl checkValue = new TypedValueImpl((TypeImpl)this, builderCallback);
        if (this.hasConstantPool()) {
            return this.constantPools.forType(this).addOrGet(checkValue);
        }
        return checkValue;
    }

    @Override
    public TypedValueImpl asValue(Object value) {
        if (this.hasConstantPool()) {
            return this.constantPools.forType(this).addOrGet(value);
        }
        return new TypedValueImpl((TypeImpl)this, value);
    }

    @Override
    public TypedValueImpl nullValue() {
        return this.nullValue.updateAndGet(v -> v == null ? TypedValueImpl.ofNull(this) : v);
    }

    @Override
    public boolean isUsedBy(Type other) {
        if (other == null) {
            return false;
        }
        return BaseType.isUsedBy(this, (TypeImpl)other, new HashSet<TypeImpl>());
    }

    private static boolean isUsedBy(TypeImpl type1, TypeImpl type2, HashSet<TypeImpl> track) {
        if (!track.add(type2)) {
            return false;
        }
        for (TypedFieldImpl typedField : type2.getFields()) {
            if (typedField.getType().equals(type1)) {
                return true;
            }
            if (!BaseType.isUsedBy(type1, typedField.getType(), track)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseType baseType = (BaseType)o;
        return this.id == baseType.id && this.name.equals(baseType.name) && Objects.equals(this.supertype, baseType.supertype);
    }

    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = NonZeroHashCode.hash(this.id, this.name, this.supertype);
        }
        return this.hashcode;
    }

    public String toString() {
        return "BaseType [id=" + this.id + ", name=" + this.name + ", supertype=" + this.supertype + "]";
    }
}

