/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2.resolver;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.InstallableUnit;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.tycho.ArtifactKey;
import org.eclipse.tycho.DefaultArtifactKey;
import org.eclipse.tycho.IDependencyMetadata;
import org.eclipse.tycho.ReactorProject;
import org.eclipse.tycho.ReactorProjectIdentities;
import org.eclipse.tycho.artifacts.DependencyResolutionException;
import org.eclipse.tycho.artifacts.IllegalArtifactReferenceException;
import org.eclipse.tycho.artifacts.TargetPlatform;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfiguration;
import org.eclipse.tycho.core.ee.shared.ExecutionEnvironmentConfigurationStub;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.core.shared.MultiLineLogger;
import org.eclipse.tycho.core.shared.TargetEnvironment;
import org.eclipse.tycho.p2.metadata.IArtifactFacade;
import org.eclipse.tycho.p2.resolver.DefaultP2ResolutionResult;
import org.eclipse.tycho.p2.resolver.MetadataOnlyP2ResolutionResult;
import org.eclipse.tycho.p2.resolver.facade.P2ResolutionResult;
import org.eclipse.tycho.p2.resolver.facade.P2Resolver;
import org.eclipse.tycho.p2.target.ArtifactTypeHelper;
import org.eclipse.tycho.p2.target.P2TargetPlatform;
import org.eclipse.tycho.p2.target.TargetPlatformFactoryImpl;
import org.eclipse.tycho.p2.target.facade.PomDependencyCollector;
import org.eclipse.tycho.p2.target.facade.TargetPlatformConfigurationStub;
import org.eclipse.tycho.p2.util.resolution.AbstractResolutionStrategy;
import org.eclipse.tycho.p2.util.resolution.DependencyCollector;
import org.eclipse.tycho.p2.util.resolution.ProjectorResolutionStrategy;
import org.eclipse.tycho.p2.util.resolution.ResolutionDataImpl;
import org.eclipse.tycho.p2.util.resolution.ResolverException;
import org.eclipse.tycho.repository.p2base.metadata.QueryableCollection;
import org.eclipse.tycho.repository.util.LoggingProgressMonitor;

public class P2ResolverImpl
implements P2Resolver {
    private final MavenLogger logger;
    private final IProgressMonitor monitor;
    private List<TargetEnvironment> environments;
    private Map<String, String> additionalFilterProperties = new HashMap<String, String>();
    private final List<IRequirement> additionalRequirements = new ArrayList<IRequirement>();
    private TargetPlatformFactoryImpl targetPlatformFactory;
    private Set<IInstallableUnit> usedTargetPlatformUnits;

    public P2ResolverImpl(TargetPlatformFactoryImpl targetPlatformFactory, MavenLogger logger) {
        this.targetPlatformFactory = targetPlatformFactory;
        this.logger = logger;
        this.monitor = new LoggingProgressMonitor(logger);
        this.environments = Collections.singletonList(TargetEnvironment.getRunningEnvironment());
    }

    public Map<TargetEnvironment, P2ResolutionResult> resolveTargetDependencies(TargetPlatform context, ReactorProject project) {
        P2TargetPlatform targetPlatform = P2ResolverImpl.getTargetFromContext(context);
        if (project != null && "eclipse-test-plugin".equals(project.getPackaging())) {
            P2ResolverImpl.addDependenciesForTests(this.additionalRequirements::add);
        }
        LinkedHashMap<TargetEnvironment, P2ResolutionResult> results = new LinkedHashMap<TargetEnvironment, P2ResolutionResult>();
        this.usedTargetPlatformUnits = new LinkedHashSet<IInstallableUnit>();
        Set metadata = project != null ? project.getDependencyMetadata(IDependencyMetadata.DependencyMetadataType.SEED) : Collections.emptySet();
        for (TargetEnvironment environment : this.environments) {
            if (P2ResolverImpl.isMatchingEnv(metadata, environment, arg_0 -> ((MavenLogger)this.logger).debug(arg_0))) {
                results.put(environment, this.resolveDependencies(Collections.emptySet(), project, new ProjectorResolutionStrategy(this.logger), environment, targetPlatform));
                continue;
            }
            this.logger.info(MessageFormat.format("Project {0}:{1}:{2} does not match environment {3} skipp dependecy resolution", project.getGroupId(), project.getArtifactId(), project.getVersion(), environment.toFilterExpression()));
        }
        targetPlatform.reportUsedLocalIUs(this.usedTargetPlatformUnits);
        this.usedTargetPlatformUnits = null;
        return results;
    }

    public Map<TargetEnvironment, P2ResolutionResult> resolveArtifactDependencies(TargetPlatform context, Collection<? extends ArtifactKey> artifacts) {
        P2TargetPlatform targetPlatform = P2ResolverImpl.getTargetFromContext(context);
        ArrayList<IInstallableUnit> roots = new ArrayList<IInstallableUnit>();
        for (ArtifactKey artifactKey : artifacts) {
            QueryableCollection queriable = new QueryableCollection(targetPlatform.getInstallableUnits());
            VersionRange range = new VersionRange(artifactKey.getVersion());
            IRequirement requirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)artifactKey.getId(), (VersionRange)range, null, (int)1, (int)Integer.MAX_VALUE, (boolean)false);
            IQueryResult result = queriable.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createMatchQuery((IExpression)requirement.getMatches(), (Object[])new Object[0])), this.monitor);
            roots.addAll(result.toUnmodifiableSet());
        }
        LinkedHashMap<TargetEnvironment, P2ResolutionResult> linkedHashMap = new LinkedHashMap<TargetEnvironment, P2ResolutionResult>();
        for (TargetEnvironment environment : this.environments) {
            linkedHashMap.put(environment, this.resolveDependencies(roots, null, new ProjectorResolutionStrategy(this.logger), environment, targetPlatform));
        }
        return linkedHashMap;
    }

    public P2ResolutionResult collectProjectDependencies(TargetPlatform context, ReactorProject project) {
        return this.resolveDependencies(Collections.emptySet(), project, new DependencyCollector(this.logger), new TargetEnvironment(null, null, null), P2ResolverImpl.getTargetFromContext(context));
    }

    public P2ResolutionResult resolveMetadata(TargetPlatformConfigurationStub tpConfiguration, ExecutionEnvironmentConfiguration eeConfig) {
        TargetPlatform contextImpl = this.targetPlatformFactory.createTargetPlatform(tpConfiguration, eeConfig, (List)null, (PomDependencyCollector)null);
        ResolutionDataImpl data = new ResolutionDataImpl(contextImpl.getEEResolutionHints());
        data.setAvailableIUs(contextImpl.getInstallableUnits());
        data.setRootIUs(new HashSet<IInstallableUnit>());
        data.setAdditionalRequirements(this.additionalRequirements);
        ProjectorResolutionStrategy strategy = new ProjectorResolutionStrategy(this.logger);
        strategy.setData(data);
        MetadataOnlyP2ResolutionResult result = new MetadataOnlyP2ResolutionResult();
        try {
            for (IInstallableUnit iu : strategy.multiPlatformResolve(this.environments, this.monitor)) {
                result.addArtifact("p2-installable-unit", iu.getId(), iu.getVersion().toString(), iu);
            }
        }
        catch (ResolverException e) {
            this.logger.error("Resolution failed:");
            new MultiLineLogger(this.logger).error(e.getDetails(), "  ");
            throw new RuntimeException(e);
        }
        return result;
    }

    public P2ResolutionResult getTargetPlatformAsResolutionResult(TargetPlatformConfigurationStub tpConfiguration, String eeName) {
        TargetPlatform targetPlatform = this.targetPlatformFactory.createTargetPlatform(tpConfiguration, (ExecutionEnvironmentConfiguration)new ExecutionEnvironmentConfigurationStub(eeName), (List)null, (PomDependencyCollector)null);
        MetadataOnlyP2ResolutionResult result = new MetadataOnlyP2ResolutionResult();
        for (IInstallableUnit iu : targetPlatform.getInstallableUnits()) {
            result.addArtifact("p2-installable-unit", iu.getId(), iu.getVersion().toString(), iu);
        }
        return result;
    }

    protected P2ResolutionResult resolveDependencies(Collection<IInstallableUnit> rootUIs, ReactorProject project, AbstractResolutionStrategy strategy, TargetEnvironment environment, P2TargetPlatform targetPlatform) {
        Collection<IInstallableUnit> newState;
        ResolutionDataImpl data = new ResolutionDataImpl(targetPlatform.getEEResolutionHints());
        Set<IInstallableUnit> availableUnits = targetPlatform.getInstallableUnits();
        if (project != null) {
            data.setRootIUs(project.getDependencyMetadata(IDependencyMetadata.DependencyMetadataType.SEED));
            Set projectSecondaryIUs = project.getDependencyMetadata(IDependencyMetadata.DependencyMetadataType.RESOLVE);
            if (!projectSecondaryIUs.isEmpty()) {
                availableUnits = new LinkedHashSet<IInstallableUnit>(availableUnits);
                availableUnits.addAll(projectSecondaryIUs);
            }
        } else {
            data.setRootIUs(rootUIs);
        }
        data.setAdditionalRequirements(this.additionalRequirements);
        data.setAvailableIUs(availableUnits);
        data.setAdditionalFilterProperties(this.additionalFilterProperties);
        strategy.setData(data);
        try {
            newState = strategy.resolve(environment, this.monitor);
        }
        catch (ResolverException e) {
            this.logger.info(e.getSelectionContext());
            this.logger.error("Cannot resolve project dependencies:");
            new MultiLineLogger(this.logger).error(e.getDetails(), "  ");
            this.logger.error("");
            this.logger.error("See https://wiki.eclipse.org/Tycho/Dependency_Resolution_Troubleshooting for help.");
            throw new DependencyResolutionException("Cannot resolve dependencies of " + project, (Throwable)e);
        }
        if (this.usedTargetPlatformUnits != null) {
            this.usedTargetPlatformUnits.addAll(newState);
        }
        return this.toResolutionResult(newState, project, targetPlatform);
    }

    private P2ResolutionResult toResolutionResult(Collection<IInstallableUnit> newState, ReactorProject project, P2TargetPlatform targetPlatform) {
        Set<IInstallableUnit> currentProjectUnits = P2ResolverImpl.getProjectUnits(project);
        DefaultP2ResolutionResult result = new DefaultP2ResolutionResult();
        for (IInstallableUnit iu : newState) {
            P2ResolverImpl.addUnit(result, iu, project, targetPlatform, currentProjectUnits);
        }
        result.removeEntriesWithUnknownType();
        targetPlatform.saveLocalMavenRepository();
        P2ResolverImpl.collectNonReactorIUs(result, newState, targetPlatform, currentProjectUnits);
        return result;
    }

    private static void addUnit(DefaultP2ResolutionResult result, IInstallableUnit iu, ReactorProject project, P2TargetPlatform targetPlatform, Set<IInstallableUnit> currentProjectUnits) {
        if (currentProjectUnits.contains(iu)) {
            P2ResolverImpl.addReactorProject(result, project.getIdentities(), iu);
            return;
        }
        ReactorProjectIdentities otherProject = targetPlatform.getOriginalReactorProjectMap().get(iu);
        if (otherProject != null) {
            P2ResolverImpl.addReactorProject(result, otherProject, iu);
            return;
        }
        IArtifactFacade mavenArtifact = targetPlatform.getOriginalMavenArtifactMap().get(iu);
        if (mavenArtifact != null) {
            P2ResolverImpl.addExternalMavenArtifact(result, mavenArtifact, iu);
            return;
        }
        for (IArtifactKey key : iu.getArtifacts()) {
            P2ResolverImpl.addArtifactFile(result, iu, key, targetPlatform);
        }
    }

    public void setEnvironments(List<TargetEnvironment> environments) {
        Objects.requireNonNull(environments, "environments can't be null");
        this.environments = environments;
    }

    public void setAdditionalFilterProperties(Map<String, String> additionalFilterProperties) {
        Objects.requireNonNull(this.environments, "additionalFilterProperties can't be null");
        this.additionalFilterProperties = additionalFilterProperties;
    }

    public void addDependency(String type, String id, String versionRange) throws IllegalArtifactReferenceException {
        VersionRange parsedVersionRange;
        try {
            parsedVersionRange = new VersionRange(versionRange);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArtifactReferenceException("The string \"" + versionRange + "\" is not a valid OSGi version range");
        }
        this.additionalRequirements.add(ArtifactTypeHelper.createRequirementFor(type, id, parsedVersionRange));
    }

    public void addAdditionalBundleDependency(String bundleId) {
        this.additionalRequirements.add(MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)bundleId, (VersionRange)VersionRange.emptyRange, null, (boolean)false, (boolean)true, (boolean)true));
    }

    public List<IRequirement> getAdditionalRequirements() {
        return this.additionalRequirements;
    }

    public P2ResolutionResult resolveInstallableUnit(TargetPlatform context, String id, String versionRange) {
        P2TargetPlatform targetPlatform = P2ResolverImpl.getTargetFromContext(context);
        QueryableCollection queriable = new QueryableCollection(targetPlatform.getInstallableUnits());
        VersionRange range = new VersionRange(versionRange);
        IRequirement requirement = MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)id, (VersionRange)range, null, (int)1, (int)Integer.MAX_VALUE, (boolean)false);
        IQueryResult result = queriable.query(QueryUtil.createLatestQuery((IQuery)QueryUtil.createMatchQuery((IExpression)requirement.getMatches(), (Object[])new Object[0])), this.monitor);
        Set newState = result.toUnmodifiableSet();
        return this.toResolutionResult(newState, null, targetPlatform);
    }

    private static P2TargetPlatform getTargetFromContext(TargetPlatform context) {
        Objects.requireNonNull(context, "target context can't be null");
        if (context instanceof P2TargetPlatform) {
            return (P2TargetPlatform)context;
        }
        throw new IllegalArgumentException("invalid target context-type " + context.getClass().getName() + ", required is " + P2TargetPlatform.class);
    }

    private static Set<IInstallableUnit> getProjectUnits(ReactorProject project) {
        if (project == null) {
            return Collections.emptySet();
        }
        return project.getDependencyMetadata();
    }

    private static IRequirement optionalGreedyRequirementTo(String bundleId) {
        return MetadataFactory.createRequirement((String)"org.eclipse.equinox.p2.iu", (String)bundleId, (VersionRange)VersionRange.emptyRange, null, (boolean)true, (boolean)true, (boolean)true);
    }

    private static boolean isPureIU(IInstallableUnit iu) {
        return Boolean.parseBoolean(iu.getProperty("org.eclipse.equinox.p2.type.iu"));
    }

    private static String getFeatureId(IInstallableUnit iu) {
        for (IProvidedCapability provided : iu.getProvidedCapabilities()) {
            if (!"org.eclipse.update.feature".equals(provided.getNamespace())) continue;
            return provided.getName();
        }
        return null;
    }

    private static boolean isBundleOrFragmentWithId(IInstallableUnit iu, String id) {
        for (IProvidedCapability provided : iu.getProvidedCapabilities()) {
            if (!"osgi.bundle".equals(provided.getNamespace())) continue;
            return id.equals(provided.getName());
        }
        return false;
    }

    private static boolean isProduct(IInstallableUnit iu) {
        return Boolean.parseBoolean(iu.getProperty("org.eclipse.equinox.p2.type.product"));
    }

    private static void addExternalMavenArtifact(DefaultP2ResolutionResult result, IArtifactFacade mavenArtifact, IInstallableUnit iu) {
        String id = iu.getId();
        String version = iu.getVersion().toString();
        String mavenClassifier = iu.getProperty("maven-classifier");
        File location = mavenArtifact.getLocation();
        P2ResolverImpl.addMavenArtifact(result, iu, id, version, mavenClassifier, location);
    }

    protected static void addMavenArtifact(DefaultP2ResolutionResult result, IInstallableUnit iu, String id, String version, String mavenClassifier, File location) {
        String contributingArtifactId;
        String contributingArtifactType;
        if (P2ResolverImpl.isBundleOrFragmentWithId(iu, id)) {
            contributingArtifactType = "eclipse-plugin";
            contributingArtifactId = id;
        } else {
            String featureId = P2ResolverImpl.getFeatureId(iu);
            if (featureId != null) {
                contributingArtifactType = "eclipse-feature";
                contributingArtifactId = featureId;
            } else if (P2ResolverImpl.isProduct(iu)) {
                contributingArtifactType = "eclipse-product";
                contributingArtifactId = id;
            } else if (P2ResolverImpl.isPureIU(iu)) {
                contributingArtifactType = "p2-installable-unit";
                contributingArtifactId = id;
            } else {
                contributingArtifactType = null;
                contributingArtifactId = null;
            }
        }
        result.addResolvedArtifact(Optional.ofNullable(contributingArtifactId).map(artifactId -> new DefaultArtifactKey(contributingArtifactType, artifactId, version)), mavenClassifier, iu, location);
    }

    private static void collectNonReactorIUs(DefaultP2ResolutionResult result, Collection<IInstallableUnit> newState, P2TargetPlatform targetPlatform, Set<IInstallableUnit> currentProjectUnits) {
        Map<IInstallableUnit, ReactorProjectIdentities> reactorProjectLookup = targetPlatform.getOriginalReactorProjectMap();
        for (IInstallableUnit iu : newState) {
            if (currentProjectUnits.contains(iu) || reactorProjectLookup.get(iu) != null) continue;
            result.addNonReactorUnit(iu);
        }
    }

    private static void addReactorProject(DefaultP2ResolutionResult result, ReactorProjectIdentities project, IInstallableUnit iu) {
        String id = iu.getId();
        String version = iu.getVersion().toString();
        String mavenClassifier = iu.getProperty("maven-classifier");
        File location = project.getBasedir();
        P2ResolverImpl.addMavenArtifact(result, iu, id, version, mavenClassifier, location);
    }

    private static void addArtifactFile(DefaultP2ResolutionResult result, IInstallableUnit iu, IArtifactKey p2ArtifactKey, P2TargetPlatform context) {
        String id = iu.getId();
        String version = iu.getVersion().toString();
        String mavenClassifier = null;
        if ("osgi.bundle".equals(p2ArtifactKey.getClassifier())) {
            DefaultArtifactKey artifactKey = new DefaultArtifactKey("eclipse-plugin", id, version);
            result.addArtifact((ArtifactKey)artifactKey, mavenClassifier, iu, p2ArtifactKey, context);
        } else if ("org.eclipse.update.feature".equals(p2ArtifactKey.getClassifier())) {
            String featureId = P2ResolverImpl.getFeatureId(iu);
            if (featureId != null) {
                DefaultArtifactKey artifactKey = new DefaultArtifactKey("eclipse-feature", featureId, version);
                result.addArtifact((ArtifactKey)artifactKey, mavenClassifier, iu, p2ArtifactKey, context);
            }
        } else {
            DefaultArtifactKey key = new DefaultArtifactKey("p2-installable-unit", id, version);
            result.addArtifact((ArtifactKey)key, mavenClassifier, iu, p2ArtifactKey, context);
        }
    }

    private static boolean isMatchingEnv(Set<?> metadata, TargetEnvironment environment, Consumer<String> debugConsumer) {
        if (metadata != null) {
            for (Object meta : metadata) {
                IMatchExpression filter;
                if (!(meta instanceof IInstallableUnit) || (filter = ((IInstallableUnit)meta).getFilter()) == null) continue;
                boolean match = filter.isMatch((Object)InstallableUnit.contextIU((Map)environment.toFilterProperties()));
                debugConsumer.accept(MessageFormat.format("{0}: {1} (matches {2})", filter, Arrays.toString(filter.getParameters()), match));
                if (match) continue;
                return false;
            }
        }
        return true;
    }

    private static void addDependenciesForTests(Consumer<IRequirement> requirementsConsumer) {
        requirementsConsumer.accept(P2ResolverImpl.optionalGreedyRequirementTo("org.eclipse.equinox.launcher"));
        requirementsConsumer.accept(P2ResolverImpl.optionalGreedyRequirementTo("org.eclipse.core.runtime"));
        requirementsConsumer.accept(P2ResolverImpl.optionalGreedyRequirementTo("org.eclipse.ui.ide.application"));
    }
}

