/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.shared;

import org.eclipse.tycho.core.shared.MavenLogger;

public class MultiLineLogger
implements MavenLogger {
    private final MavenLogger delegate;

    public MultiLineLogger(MavenLogger delegate) {
        this.delegate = delegate;
    }

    @Override
    public void error(String message) {
        String[] stringArray = message.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String messageLine = stringArray[n2];
            this.delegate.error(messageLine);
            ++n2;
        }
    }

    @Override
    public void error(String message, Throwable cause) {
        String[] messageLines = message.split("\n");
        int ix = 0;
        while (ix < messageLines.length - 1) {
            String messageLine = messageLines[ix];
            this.delegate.error(messageLine);
            ++ix;
        }
        if (messageLines.length > 0) {
            String lastMessageLine = messageLines[messageLines.length - 1];
            this.delegate.error(lastMessageLine, cause);
        }
    }

    public void error(String message, String prefix) {
        String[] stringArray = message.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String messageLine = stringArray[n2];
            this.delegate.error(String.valueOf(prefix) + messageLine);
            ++n2;
        }
    }

    @Override
    public void warn(String message) {
        String[] stringArray = message.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String messageLine = stringArray[n2];
            this.delegate.warn(messageLine);
            ++n2;
        }
    }

    @Override
    public void warn(String message, Throwable cause) {
        String[] messageLines = message.split("\n");
        int ix = 0;
        while (ix < messageLines.length - 1) {
            String messageLine = messageLines[ix];
            this.delegate.warn(messageLine);
            ++ix;
        }
        if (messageLines.length > 0) {
            String lastMessageLine = messageLines[messageLines.length - 1];
            this.delegate.warn(lastMessageLine, cause);
        }
    }

    @Override
    public void info(String message) {
        String[] stringArray = message.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String messageLine = stringArray[n2];
            this.delegate.info(messageLine);
            ++n2;
        }
    }

    @Override
    public void debug(String message) {
        String[] stringArray = message.split("\n");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String messageLine = stringArray[n2];
            this.delegate.debug(messageLine);
            ++n2;
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    @Override
    public boolean isExtendedDebugEnabled() {
        return this.delegate.isExtendedDebugEnabled();
    }
}

