/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.util;

import clover.org.jfree.chart.ChartFactory;
import clover.org.jfree.chart.ChartRenderingInfo;
import clover.org.jfree.chart.ChartUtilities;
import clover.org.jfree.chart.JFreeChart;
import clover.org.jfree.chart.annotations.XYPointerAnnotation;
import clover.org.jfree.chart.axis.AxisLocation;
import clover.org.jfree.chart.axis.DateAxis;
import clover.org.jfree.chart.axis.LogarithmicAxis;
import clover.org.jfree.chart.axis.NumberAxis;
import clover.org.jfree.chart.axis.NumberTickUnit;
import clover.org.jfree.chart.axis.ValueAxis;
import clover.org.jfree.chart.labels.StandardXYToolTipGenerator;
import clover.org.jfree.chart.labels.XYToolTipGenerator;
import clover.org.jfree.chart.plot.PlotOrientation;
import clover.org.jfree.chart.plot.XYPlot;
import clover.org.jfree.chart.renderer.xy.XYItemRenderer;
import clover.org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import clover.org.jfree.chart.urls.XYURLGenerator;
import clover.org.jfree.data.xy.XYDataItem;
import clover.org.jfree.data.xy.XYDataset;
import clover.org.jfree.data.xy.XYSeries;
import clover.org.jfree.data.xy.XYSeriesCollection;
import clover.org.jfree.ui.RectangleInsets;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.reporters.Column;
import com.atlassian.clover.reporters.Columns;
import com.atlassian.clover.reporters.Historical;
import com.atlassian.clover.reporters.html.HtmlRenderingSupportImpl;
import com.atlassian.clover.util.Formatting;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloverChartFactory {
    private static final HtmlRenderingSupportImpl HTML_HELPER = new HtmlRenderingSupportImpl();
    private static final int BUCKETS = 11;
    protected static final String HISTOGRAM_NAME = "classDistrubutionChart.png";
    private static final String HISTOGRAM_TITLE = "Class Coverage Distribution";
    protected static final String SCATTER_NAME = "classComplexityChart.png";
    private static final String SCATTER_TITLE = "Class Complexity";
    private static final String SRC_FILE_CHART_NAME = "srcFileCovDistChart";
    private static final String SRC_FILE_CHART_TEXT = "of files have more coverage";
    private static final Color TRANSPARENT_BACKGROUND = new Color(255, 255, 255, 0);
    private static final Color SERIES_COLOR = new Color(71, 142, 199);
    private static final Color SERIES_HIGHLIGHT = new Color(219, 85, 22);
    private static final Font AXIS_FONT = new Font("Arial", 0, 11);
    private static final int WIDTH_LARGE = 304;
    private static final int HEIGHT_LARGE = 171;
    private static final int WIDTH_SMALL = 100;
    private static final int HEIGHT_SMALL = 55;
    private static final Color TOPLINE_DARK = new Color(12, 135, 201);
    private static final Color TOPLINE_LIGHT = new Color(230, 242, 250);
    private static final Color LIGHT_BLUE = new Color(71, 142, 199);
    private static final Color KHAKI = new Color(118, 152, 16);
    private static final Color ORANGE_XY = new Color(215, 86, 31);
    private static final Color YELLOW_XY = new Color(222, 228, 57);
    private static final Color DARK_BLUE = new Color(12, 67, 131);
    private static final Color GREEN = new Color(95, 190, 65);
    private static final Color LIGHT_ORANGE = new Color(245, 131, 43);
    private static final Color LIGHT_YELLOW = new Color(237, 239, 0);
    private static final Color BRIGHT_BLUE = new Color(12, 135, 201);
    private static final Color DIRTY_RED = new Color(173, 42, 21);
    private static final Color GREEN2 = new Color(174, 191, 71);
    private static final Color[] LINE_COLOURS_XY = new Color[]{DIRTY_RED, DARK_BLUE, GREEN, LIGHT_BLUE, BRIGHT_BLUE, ORANGE_XY, KHAKI, YELLOW_XY, LIGHT_ORANGE, LIGHT_YELLOW, TOPLINE_LIGHT, GREEN2};

    public static ChartInfo getChartForFile(FullFileInfo fileInfo, Map<Integer, ChartInfo> charts) {
        double coverage = fileInfo.getMetrics().getPcCoveredElements();
        if (coverage >= 0.0 && !fileInfo.isTestFile()) {
            return charts.get(CloverChartFactory.getDataIndex(fileInfo.getMetrics().getPcCoveredElements()));
        }
        return null;
    }

    public static ChartInfo generateHistogramChart(List appClasses, File basePath) throws IOException {
        JFreeChart chart = CloverChartFactory.createClassCoverageChart("Coverage", "# Classes", appClasses, "class");
        ChartRenderingInfo renderingInfo = new ChartRenderingInfo();
        ChartUtilities.saveChartAsPNG(new File(basePath, HISTOGRAM_NAME), chart, 304, 171, renderingInfo, true, 1);
        return new ChartInfo(HISTOGRAM_NAME, ChartUtilities.getImageMap(HISTOGRAM_NAME, renderingInfo), 0, "", HISTOGRAM_TITLE);
    }

    public static ChartInfo generateScatterChart(List appClasses, File basePath) throws IOException {
        JFreeChart chart = CloverChartFactory.createComplexityCoverageChart("Coverage", "Complexity", appClasses, "Cmp: {2}; Cov: {1}; ");
        ChartRenderingInfo renderingInfo = new ChartRenderingInfo();
        ChartUtilities.saveChartAsPNG(new File(basePath, SCATTER_NAME), chart, 304, 171, renderingInfo, true, 1);
        return new ChartInfo(SCATTER_NAME, ChartUtilities.getImageMap(SCATTER_NAME, renderingInfo), 0, "", SCATTER_TITLE);
    }

    public static Map generateSrcFileCharts(List appFiles, File basePath) throws IOException {
        HashMap<Integer, ChartInfo> chartMap = new HashMap<Integer, ChartInfo>();
        JFreeChart chart = CloverChartFactory.createClassCoverageChart("Coverage", "# Files", appFiles, "file");
        XYPlot plot = chart.getXYPlot();
        plot.getDomainAxis().setVisible(false);
        plot.getRangeAxis(0).setVisible(false);
        plot.getRangeAxis(1).setVisible(false);
        plot.setRangeGridlinesVisible(false);
        plot.setBackgroundPaint(TRANSPARENT_BACKGROUND);
        chart.setBackgroundPaint(TRANSPARENT_BACKGROUND);
        int totalClasses = 0;
        for (int i = 0; i < 11; ++i) {
            totalClasses += (int)plot.getDataset().getYValue(0, i);
        }
        int higherPc = totalClasses;
        XYPointerAnnotation annotation = CloverChartFactory.getAnnotation();
        plot.addAnnotation(annotation);
        plot.getRangeAxis().setLowerBound(-(0.15 * plot.getRangeAxis().getUpperBound()));
        annotation.setY(plot.getRangeAxis().getUpperBound() * 0.25);
        for (int i = 0; i < 11; ++i) {
            annotation.setX(i * 10);
            String chartName = SRC_FILE_CHART_NAME + i + ".png";
            ChartRenderingInfo renderingInfo = new ChartRenderingInfo();
            ChartUtilities.saveChartAsPNG(new File(basePath, chartName), chart, 100, 55, renderingInfo, true, 1);
            higherPc = (int)((double)higherPc - plot.getDataset().getYValue(0, i));
            int pcPosition = totalClasses != 0 ? (int)((double)higherPc / (double)totalClasses * 100.0) : 0;
            ChartInfo chartInfo = new ChartInfo(chartName, ChartUtilities.getImageMap(chartName, renderingInfo), pcPosition, SRC_FILE_CHART_TEXT, "");
            chartMap.put(new Integer(i), chartInfo);
        }
        return chartMap;
    }

    protected static JFreeChart createComplexityCoverageChart(String xLabel, String yLabel, List appClasses, String toolTip) {
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        JFreeChart chart = ChartFactory.createScatterPlot("", "", "", seriesCollection, PlotOrientation.VERTICAL, false, true, false);
        chart.setBackgroundPaint(TRANSPARENT_BACKGROUND);
        XYSeries series = new XYSeries((Comparable)((Object)""), false, true);
        seriesCollection.addSeries(series);
        HashMap<XYDataItem, BaseClassInfo> classInfoMap = new HashMap<XYDataItem, BaseClassInfo>();
        for (int i = 0; i < appClasses.size(); ++i) {
            BaseClassInfo classInfo = (BaseClassInfo)appClasses.get(i);
            int covered = (int)(classInfo.getMetrics().getPcCoveredElements() * 100.0f);
            if (covered < 0) continue;
            XYDataItem item = new XYDataItem(covered, classInfo.getMetrics().getComplexity());
            series.add(item);
            classInfoMap.put(item, classInfo);
        }
        NumberAxis yAxis = CloverChartFactory.getDashboardYAxis("", chart.getXYPlot().getRangeAxis().getRange().getUpperBound());
        NumberAxis xAxis = CloverChartFactory.configureDashboardXAxis(xLabel, chart.getXYPlot().getDomainAxis());
        NumberAxis yAxisLabel = CloverChartFactory.getDashboardYAxis(yLabel, 0.0);
        yAxisLabel.setTickLabelsVisible(false);
        XYPlot plot = CloverChartFactory.getDashboardXYPlot(chart, xAxis, yAxis, yAxisLabel);
        XYItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesShape(0, new Ellipse2D.Double(0.0, 0.0, 5.0, 5.0));
        renderer.setBaseToolTipGenerator(CloverChartFactory.getXYToolTipGeneratorComplexityCoverage(classInfoMap, toolTip));
        renderer.setURLGenerator(CloverChartFactory.getXYURLGenerator(classInfoMap));
        renderer.setSeriesPaint(0, SERIES_COLOR);
        yAxis.setAutoRange(true);
        return chart;
    }

    protected static JFreeChart createClassCoverageChart(String xLabel, String yLabel, List appClasses, String toolTip) {
        int[] data = CloverChartFactory.generateClassCoverageData(appClasses);
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        JFreeChart chart = ChartFactory.createHistogram("", "", "", seriesCollection, PlotOrientation.VERTICAL, false, true, false);
        chart.setBackgroundPaint(TRANSPARENT_BACKGROUND);
        XYSeries series = new XYSeries((Comparable)((Object)""));
        seriesCollection.addSeries(series);
        for (int i = 0; i < data.length; ++i) {
            series.add((double)i * CloverChartFactory.getBucketSize(), data[i]);
        }
        seriesCollection.setAutoWidth(true);
        seriesCollection.setIntervalWidth(seriesCollection.getIntervalWidth() * 0.9);
        NumberAxis xAxis = CloverChartFactory.configureDashboardXAxis(xLabel, chart.getXYPlot().getDomainAxis());
        NumberAxis yAxis = CloverChartFactory.getDashboardYAxis("", chart.getXYPlot().getRangeAxis().getRange().getLength());
        NumberAxis yAxisLabel = CloverChartFactory.getDashboardYAxis(yLabel, 0.0);
        yAxisLabel.setTickLabelsVisible(false);
        XYPlot plot = CloverChartFactory.getDashboardXYPlot(chart, xAxis, yAxis, yAxisLabel);
        XYItemRenderer renderer = plot.getRenderer();
        renderer.setSeriesPaint(0, SERIES_COLOR);
        renderer.setBaseToolTipGenerator(CloverChartFactory.getXYToolTipGeneratorClassCoverage(toolTip));
        return chart;
    }

    private static XYPointerAnnotation getAnnotation() {
        XYPointerAnnotation annotation = new XYPointerAnnotation("", 0.0, 0.0, 1.5707963267948966);
        annotation.setArrowPaint(SERIES_HIGHLIGHT);
        annotation.setArrowLength(8.0);
        annotation.setArrowWidth(4.0);
        annotation.setLabelOffset(0.0);
        return annotation;
    }

    public static JFreeChart createJFreeChart(Historical.Chart chartCfg, Map data) {
        NumberAxis yAxis;
        DateAxis xAxis = new DateAxis(chartCfg.getXLabel());
        if (chartCfg.isLogScale()) {
            yAxis = new LogarithmicAxis(chartCfg.getYLabel());
            ((LogarithmicAxis)yAxis).setAutoRangeNextLogFlag(true);
        } else {
            yAxis = new NumberAxis(chartCfg.getYLabel());
        }
        XYSeriesCollection seriesCollection = new XYSeriesCollection();
        JFreeChart chart = ChartFactory.createXYLineChart(chartCfg.getTitle(), "", "", seriesCollection, PlotOrientation.VERTICAL, true, true, false);
        XYPlot plot = chart.getXYPlot();
        XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseToolTipGenerator(CloverChartFactory.getXYToolTipGenerator("{0}: {1}, {2}"));
        plot.setBackgroundAlpha(0.0f);
        chart.setBackgroundPaint(Color.white);
        int j = 0;
        Columns columns = chartCfg.getColumns();
        for (Column col : columns.getProjectColumns()) {
            XYSeries series = new XYSeries((Comparable)((Object)col.getTitle()));
            seriesCollection.addSeries(series);
            renderer.setSeriesItemLabelsVisible(j, true);
            renderer.setSeriesShapesVisible(j, true);
            renderer.setSeriesShapesFilled(j, true);
            renderer.setSeriesShape(j, new RoundRectangle2D.Float(-2.0f, -2.0f, 4.0f, 4.0f, 4.0f, 4.0f));
            renderer.setSeriesPaint(j, LINE_COLOURS_XY[j % LINE_COLOURS_XY.length]);
            renderer.setSeriesStroke(j, new BasicStroke(2.0f, 1, 0));
            ++j;
            for (Map.Entry entry : data.entrySet()) {
                HasMetrics hasMetrics = (HasMetrics)entry.getValue();
                Long timestamp = (Long)entry.getKey();
                try {
                    col.init(hasMetrics.getMetrics());
                }
                catch (CloverException e) {
                    Logger.getInstance().debug("Skipping data for column: " + col.getName(), e);
                    continue;
                }
                Number yVal = col.getNumber();
                if (chartCfg.isLogScale() && yVal.floatValue() <= 0.0f) {
                    Logger.getInstance().debug(col.getTitle() + " xVal " + timestamp + " yVal = " + yVal + ". Skipping this datapoint.");
                    continue;
                }
                series.add(timestamp, yVal);
            }
        }
        plot.setDomainAxis(xAxis);
        plot.setRangeAxis(yAxis);
        yAxis.setTickLabelsVisible(true);
        if (chartCfg.isAutoRange()) {
            yAxis.setAutoRange(true);
            yAxis.setAutoRangeIncludesZero(false);
        } else {
            if (!chartCfg.isLogScale()) {
                yAxis.setLowerBound(0.0);
            }
            if (chartCfg.getUpperBound() >= 0) {
                yAxis.setUpperBound(chartCfg.getUpperBound());
            }
        }
        return chart;
    }

    private static XYURLGenerator getXYURLGenerator(final Map classInfoMap) {
        return new XYURLGenerator(){

            public String generateURL(XYDataset dataset, int series, int item) {
                XYDataItem key = new XYDataItem(dataset.getX(series, item), dataset.getY(series, item));
                BaseClassInfo classInfo = (BaseClassInfo)classInfoMap.get(key);
                return new String(HTML_HELPER.getSrcFileLink(true, classInfo));
            }
        };
    }

    private static XYToolTipGenerator getXYToolTipGeneratorComplexityCoverage(final Map classInfoMap, String format) {
        return new StandardXYToolTipGenerator(format, Formatting.getPcFormat(), NumberFormat.getInstance()){

            public String generateToolTip(XYDataset dataset, int series, int item) {
                String toolTip = super.generateToolTip(dataset, series, item);
                XYDataItem key = new XYDataItem(dataset.getX(series, item), dataset.getY(series, item));
                BaseClassInfo classInfo = (BaseClassInfo)classInfoMap.get(key);
                return toolTip + classInfo.getName();
            }
        };
    }

    public static XYToolTipGenerator getXYToolTipGenerator(String format) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return new StandardXYToolTipGenerator(format, (DateFormat)dateFormat, NumberFormat.getInstance());
    }

    private static XYToolTipGenerator getXYToolTipGeneratorClassCoverage(final String format) {
        return new StandardXYToolTipGenerator(format, NumberFormat.getInstance(), NumberFormat.getInstance()){

            public String generateToolTip(XYDataset dataset, int series, int item) {
                String xValStr;
                int xVal = dataset.getX(series, item).intValue();
                int yVal = dataset.getY(series, item).intValue();
                String yValStr = Formatting.pluralizedVal(yVal, format) + " " + (yVal != 1 ? "have" : "has");
                if (xVal == 0) {
                    xValStr = xVal + "% coverage";
                } else {
                    int prevXVal = xVal - (int)CloverChartFactory.getBucketSize() + 1;
                    xValStr = prevXVal + "-" + xVal + "% coverage";
                }
                return yValStr + " " + xValStr;
            }
        };
    }

    private static XYPlot getDashboardXYPlot(JFreeChart chart, NumberAxis xAxis, NumberAxis yAxis, NumberAxis yAxisLabel) {
        XYPlot plot = chart.getXYPlot();
        plot.setBackgroundPaint(TRANSPARENT_BACKGROUND);
        plot.setDomainGridlinesVisible(false);
        plot.setOutlineVisible(false);
        plot.setDomainAxis(0, xAxis);
        plot.setRangeAxis(0, yAxis);
        plot.setRangeAxis(1, yAxisLabel);
        plot.setRangeAxisLocation(0, AxisLocation.BOTTOM_OR_RIGHT);
        return plot;
    }

    private static NumberAxis getDashboardYAxis(String label, double maxValue) {
        NumberAxis yAxis = new NumberAxis(label);
        yAxis.setLabelFont(AXIS_FONT);
        yAxis.setAutoRangeIncludesZero(true);
        yAxis.setAxisLineVisible(false);
        yAxis.setTickLabelsVisible(true);
        yAxis.setTickMarksVisible(false);
        yAxis.setLowerBound(0.0);
        yAxis.setAutoRange(true);
        yAxis.setTickUnit(new NumberTickUnit(CloverChartFactory.getDashboardYAxisTickUnit(maxValue)));
        return yAxis;
    }

    public static int getDashboardYAxisTickUnit(double upperBound) {
        double goal = upperBound / 2.5;
        double tickValue = 1.0;
        double returnValue = 1.0;
        while (tickValue <= goal) {
            returnValue = tickValue;
            if ((tickValue *= 2.5) <= goal) {
                returnValue = tickValue;
            }
            if ((tickValue *= 2.0) <= goal) {
                returnValue = tickValue;
            }
            if (!((tickValue *= 2.0) <= goal)) continue;
            returnValue = tickValue;
        }
        return (int)returnValue;
    }

    private static NumberAxis configureDashboardXAxis(String label, ValueAxis domainAxis) {
        NumberAxis xAxis = (NumberAxis)domainAxis;
        if (xAxis == null) {
            xAxis = new NumberAxis();
        }
        xAxis.setLabel(label);
        xAxis.setLabelFont(AXIS_FONT);
        xAxis.setAutoRange(true);
        xAxis.setLowerBound(-10.0);
        xAxis.setUpperBound(110.0);
        xAxis.setAxisLineVisible(false);
        xAxis.setAutoRangeIncludesZero(true);
        xAxis.setAutoTickUnitSelection(false);
        xAxis.setTickUnit(new NumberTickUnit(100.0, Formatting.getPcFormat()), true, true);
        xAxis.setTickMarksVisible(false);
        xAxis.setLabelInsets(new RectangleInsets(-12.0, 0.0, 0.0, 0.0));
        return xAxis;
    }

    protected static int[] generateClassCoverageData(List hasMetrics) {
        int[] data = new int[11];
        for (HasMetrics clss : hasMetrics) {
            double covered = clss.getMetrics().getPcCoveredElements();
            int index = CloverChartFactory.getDataIndex(covered);
            if (index < 0) continue;
            int n = index;
            data[n] = data[n] + 1;
        }
        return data;
    }

    public static int getDataIndex(double covered) {
        if (covered < 0.0 || covered > 1.0) {
            return -1;
        }
        if (covered == 0.0) {
            return 0;
        }
        int coveredInt = (int)(covered * 100.0);
        return (int)Math.floor((double)(coveredInt - 1) / CloverChartFactory.getBucketSize()) + 1;
    }

    public static double getBucketSize() {
        return 10.0;
    }

    public static class ChartInfo {
        private final String name;
        private final String imageMap;
        private final int extraNum;
        private final String text;
        private final String title;

        public ChartInfo(String name, String imageMap, int extraNum, String text, String title) {
            this.name = name;
            this.imageMap = imageMap;
            this.extraNum = extraNum;
            this.text = text;
            this.title = title;
        }

        public String getName() {
            return this.name;
        }

        public String getImageMap() {
            return this.imageMap;
        }

        public int getExtraNum() {
            return this.extraNum;
        }

        public String getText() {
            return this.text;
        }

        public String getTitle() {
            return this.title;
        }
    }
}

