/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.reporters.console;

import com.atlassian.clover.CodeType;
import com.atlassian.clover.reporters.Current;
import com.atlassian.clover.reporters.Format;
import com.atlassian.clover.reporters.console.ReportingLevel;
import java.util.Locale;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleReporterConfig
extends Current {
    private CodeType codeType = CodeType.APPLICATION;
    @NotNull
    private ReportingLevel reportingLevel = ReportingLevel.SUMMARY;
    @Nullable
    private Set<String> packageSet;
    private boolean showUnitTests;

    public CodeType getCodeType() {
        return this.codeType;
    }

    public void setCodeType(CodeType codeType) {
        this.codeType = codeType;
    }

    @NotNull
    public ReportingLevel getLevel() {
        return this.reportingLevel;
    }

    public void setLevel(@NotNull ReportingLevel level) {
        this.reportingLevel = level;
    }

    public void setLevel(@NotNull String level) throws IllegalArgumentException {
        this.reportingLevel = ReportingLevel.valueOf(level.toUpperCase(Locale.ENGLISH));
    }

    @Nullable
    public Set<String> getPackageSet() {
        return this.packageSet;
    }

    public void setPackageSet(@Nullable Set<String> packageSet) {
        this.packageSet = packageSet;
    }

    public boolean isShowUnitTests() {
        return this.showUnitTests;
    }

    public void setShowUnitTests(boolean showUnitTests) {
        this.showUnitTests = showUnitTests;
    }

    @Override
    public boolean validate() {
        if (this.getInitString() == null || this.getInitString().length() == 0) {
            this.setFailureReason("initstring not specified.");
            return false;
        }
        if (this.getFormat() == null) {
            this.setFormat(Format.DEFAULT_TEXT);
        }
        return true;
    }
}

