/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.registry.entities;

import com.atlassian.clover.api.registry.Annotation;
import com.atlassian.clover.api.registry.ModifiersInfo;
import com.atlassian.clover.io.tags.TaggedDataInput;
import com.atlassian.clover.io.tags.TaggedDataOutput;
import com.atlassian.clover.io.tags.TaggedPersistent;
import com.atlassian.clover.registry.entities.AnnotationImpl;
import com.atlassian.clover.registry.entities.Modifier;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Modifiers
implements TaggedPersistent,
ModifiersInfo {
    private int mask = 0;
    @NotNull
    private Map<String, Collection<Annotation>> annotations = new HashMap<String, Collection<Annotation>>();

    public static Modifiers createFrom(int modifiers, @Nullable AnnotationImpl[] annotations) {
        Modifiers result = new Modifiers();
        result.setMask(modifiers);
        if (annotations != null) {
            for (AnnotationImpl annotation : annotations) {
                result.addAnnotation(annotation);
            }
        }
        return result;
    }

    public Modifiers() {
    }

    public Modifiers(@Nullable ModifiersInfo modifiers) {
        if (modifiers != null) {
            this.mask = modifiers.getMask();
            for (Collection<Annotation> annotationsLists : modifiers.getAnnotations().values()) {
                for (Annotation annotation : annotationsLists) {
                    this.addAnnotation(new AnnotationImpl(annotation));
                }
            }
        }
    }

    public boolean containsAnnotation(@NotNull String name) {
        return this.annotations.containsKey(name);
    }

    public boolean containsAnnotation(@NotNull Pattern pattern) {
        for (String annotationName : this.annotations.keySet()) {
            if (!pattern.matcher(annotationName).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<Annotation> getAnnotation(@NotNull String name) {
        Collection<Annotation> value = this.annotations.get(name);
        return value != null ? Collections.unmodifiableCollection(value) : Collections.emptyList();
    }

    @Override
    @NotNull
    public Map<String, Collection<Annotation>> getAnnotations() {
        return Collections.unmodifiableMap(this.annotations);
    }

    public void addAnnotation(AnnotationImpl annotation) {
        Collection<Annotation> values = this.annotations.get(annotation.getName());
        if (values == null) {
            values = new ArrayList<Annotation>(1);
        }
        values.add(annotation);
        this.annotations.put(annotation.getName(), values);
    }

    public void clearAnnotations() {
        this.annotations.clear();
    }

    public void setMask(int mask) {
        this.mask = mask;
    }

    @Override
    public int getMask() {
        return this.mask;
    }

    public String getVisibility() {
        int visibilityMods = this.mask & 7;
        if (visibilityMods == 0) {
            return "package";
        }
        return Modifier.toString(visibilityMods);
    }

    @Override
    public void write(TaggedDataOutput out) throws IOException {
        out.writeInt(this.mask);
        int size = 0;
        for (Collection<Annotation> annotationCollection : this.annotations.values()) {
            size += annotationCollection.size();
        }
        out.writeInt(size);
        for (Collection<Annotation> annotationCollection : this.annotations.values()) {
            for (Annotation annotation : annotationCollection) {
                out.write(AnnotationImpl.class, (AnnotationImpl)annotation);
            }
        }
    }

    public static Modifiers read(TaggedDataInput in) throws IOException {
        Modifiers result = new Modifiers();
        result.setMask(in.readInt());
        int entriesSize = in.readInt();
        for (int i = 0; i < entriesSize; ++i) {
            result.addAnnotation(in.read(AnnotationImpl.class));
        }
        return result;
    }

    public String toString() {
        return "Modifiers{modifiers=" + Modifier.toString(this.mask) + ", annotations=" + this.annotations + '}';
    }
}

