/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.recorder;

import com.atlassian.clover.ErrorInfo;
import com.atlassian.clover.Logger;
import com.atlassian.clover.recorder.CoverageSnapshot;
import com.atlassian.clover.recorder.NullRecorder;
import com.atlassian.clover.util.CloverBitSet;
import com_cenqua_clover.Clover;
import com_cenqua_clover.CloverProfile;
import com_cenqua_clover.CoverageRecorder;
import org.jetbrains.annotations.Nullable;

public class DelayedRecorder
extends CoverageRecorder {
    private final RecorderDelegateConstructor delegateConstructor;
    private transient CoverageRecorder delegate = NullRecorder.INSTANCE;
    private transient RecordingState state = RecordingState.WaitingForClover;

    public DelayedRecorder(final String initString, final long dbVersion, final long cfgbits, final int maxNumElements, final CloverProfile[] profiles, final String ... nvpProperties) {
        this.delegateConstructor = new RecorderDelegateConstructor(){

            public CoverageRecorder create() {
                return Clover.getRecorder(initString, dbVersion, cfgbits, maxNumElements, profiles, nvpProperties);
            }
        };
    }

    private synchronized void changeState(RecordingState state, CoverageRecorder delegate) {
        this.state = state;
        this.delegate = delegate;
    }

    private CoverageRecorder syncWithCloverRuntime() {
        this.state.syncWithCloverRuntime(this, this.delegateConstructor);
        return this.delegate;
    }

    public String getDbName() {
        return this.syncWithCloverRuntime().getDbName();
    }

    public String getRecordingName() {
        return this.syncWithCloverRuntime().getRecordingName();
    }

    public long getDbVersion() {
        return this.syncWithCloverRuntime().getDbVersion();
    }

    public CloverBitSet compareCoverageWith(CoverageSnapshot before) {
        return this.syncWithCloverRuntime().compareCoverageWith(before);
    }

    public CloverBitSet createEmptyHitsMask() {
        return this.syncWithCloverRuntime().createEmptyHitsMask();
    }

    public void startRun() {
        this.syncWithCloverRuntime().startRun();
    }

    public void flushNeeded() {
        this.syncWithCloverRuntime().flushNeeded();
    }

    public void maybeFlush() {
        this.syncWithCloverRuntime().maybeFlush();
    }

    public void forceFlush() {
        this.syncWithCloverRuntime().forceFlush();
    }

    public void flush() {
        this.syncWithCloverRuntime().flush();
    }

    public void sliceStart(String runtimeType, long ts, int id, int rid) {
        this.syncWithCloverRuntime().sliceStart(runtimeType, ts, id, rid);
    }

    public void sliceEnd(String runtimeType, String method, String runtimeTestName, long ts, int id, int rid, int exitStatus, ErrorInfo errorInfo) {
        this.syncWithCloverRuntime().sliceEnd(runtimeType, method, runtimeTestName, ts, id, rid, exitStatus, errorInfo);
    }

    public void inc(int index) {
        this.syncWithCloverRuntime().inc(index);
    }

    public int iget(int index) {
        return this.syncWithCloverRuntime().iget(index);
    }

    public CoverageRecorder withCapacityFor(int maxNumElements) {
        return this.syncWithCloverRuntime().withCapacityFor(maxNumElements);
    }

    public void globalSliceStart(String runtimeType, int id) {
        this.syncWithCloverRuntime().globalSliceStart(runtimeType, id);
    }

    public void globalSliceStart(String runtimeType, int id, long startTime) {
        this.syncWithCloverRuntime().globalSliceStart(runtimeType, id, startTime);
    }

    public void globalSliceEnd(String runtimeType, String method, @Nullable String runtimeTestName, int id) {
        this.syncWithCloverRuntime().globalSliceEnd(runtimeType, method, runtimeTestName, id);
    }

    public void globalSliceEnd(String runtimeType, String method, @Nullable String runtimeTestName, int id, int exitStatus, Throwable throwable) {
        this.syncWithCloverRuntime().globalSliceEnd(runtimeType, method, runtimeTestName, id, exitStatus, throwable);
    }

    public CoverageSnapshot getCoverageSnapshot() {
        return this.syncWithCloverRuntime().getCoverageSnapshot();
    }

    private static interface RecorderDelegateConstructor {
        public CoverageRecorder create();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RecordingState {
        WaitingForClover{

            public void syncWithCloverRuntime(DelayedRecorder delayedRecorder, RecorderDelegateConstructor constructor) {
                if (Clover.isInitialised()) {
                    Logger.getInstance().warn("Re-entrant Clover initialisation detected. Some coverage may not have been recorded before this point.");
                    delayedRecorder.changeState(1.Running, constructor.create());
                }
            }
        }
        ,
        Running{

            public void syncWithCloverRuntime(DelayedRecorder delayedRecorder, RecorderDelegateConstructor constructor) {
            }
        };


        public abstract void syncWithCloverRuntime(DelayedRecorder var1, RecorderDelegateConstructor var2);
    }
}

