/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.model;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.api.registry.HasMetrics;
import com.atlassian.clover.api.registry.SourceInfo;
import com.atlassian.clover.model.CoverageDataPoint;
import com.atlassian.clover.registry.FixedSourceRegion;
import com.atlassian.clover.registry.entities.BaseClassInfo;
import com.atlassian.clover.registry.entities.BaseFileInfo;
import com.atlassian.clover.registry.entities.BasePackageInfo;
import com.atlassian.clover.registry.entities.FullClassInfo;
import com.atlassian.clover.registry.entities.FullFileInfo;
import com.atlassian.clover.registry.entities.FullPackageInfo;
import com.atlassian.clover.registry.entities.FullProjectInfo;
import com.atlassian.clover.registry.entities.Modifiers;
import com.atlassian.clover.registry.metrics.ProjectMetrics;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlConverter {
    public static final int TOP_LEVEL = 0;
    public static final int PROJECT_LEVEL = 1;
    public static final int PACKAGE_LEVEL = 2;
    public static final int FILE_LEVEL = 3;
    public static final int CLASS_LEVEL = 4;
    public static final int LINE_LEVEL = 5;

    public static CoverageDataPoint getFromXmlFile(File in, int detailLevel) throws IOException, CloverException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            CoverageXMLHandler handler = new CoverageXMLHandler(detailLevel);
            parser.parse(XmlConverter.getInputStream(in), (DefaultHandler)handler);
            CoverageDataPoint result = handler.getDataPoint();
            result.setDataFile(in);
            return handler.getDataPoint();
        }
        catch (ParserConfigurationException e) {
            throw new CloverException(e);
        }
        catch (SAXException e) {
            throw new CloverException(e);
        }
    }

    private static InputStream getInputStream(File inf) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(inf));
        if (inf.getName().endsWith(".gz")) {
            return new GZIPInputStream(in);
        }
        return in;
    }

    public static class CoverageXMLHandler
    extends DefaultHandler {
        private CoverageDataPoint model;
        private FullProjectInfo project;
        private FullPackageInfo pkg;
        private FullFileInfo file;
        private HasMetrics currentEntity;
        private int currentLevel = 0;
        private int requiredLevel = 2;
        private boolean seenProjectElement = false;

        public CoverageXMLHandler(int detailLevel) {
            this.requiredLevel = detailLevel;
        }

        public void startDocument() {
            this.model = new CoverageDataPoint();
            this.seenProjectElement = false;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            if (this.seenProjectElement) {
                return;
            }
            if (qName.equals("coverage")) {
                this.model.setVersion(CoverageXMLHandler.getAttribute(atts, "clover", "????"));
                this.model.setGenerated(Long.parseLong(atts.getValue("generated")));
            } else if (qName.equals("project")) {
                this.currentLevel = 1;
                if (this.requiredLevel >= this.currentLevel) {
                    this.project = new FullProjectInfo(atts.getValue("name", ""), Long.parseLong(atts.getValue("timestamp")));
                    this.model.setProject(this.project);
                    this.currentEntity = this.project;
                }
            } else if (qName.equals("package")) {
                this.currentLevel = 2;
                if (this.requiredLevel >= this.currentLevel) {
                    this.pkg = new FullPackageInfo(this.project, atts.getValue("name"), 0);
                    this.project.addPackage(this.pkg);
                    this.currentEntity = this.pkg;
                }
            } else if (qName.equals("file")) {
                this.currentLevel = 3;
                if (this.requiredLevel >= this.currentLevel) {
                    this.file = new FullFileInfo(this.pkg, new File(atts.getValue("name")), atts.getValue("encoding"), 0, 0, 0, 0L, 0L, 0L, 0L);
                    this.pkg.addFile(this.file);
                    this.currentEntity = this.file;
                }
            } else if (qName.equals("class")) {
                this.currentLevel = 4;
                if (this.requiredLevel >= this.currentLevel) {
                    FullClassInfo clazz = new FullClassInfo(this.pkg, this.file, 0, atts.getValue("name"), (SourceInfo)new FixedSourceRegion(0, 0, 0, 0), new Modifiers(), false, false, false);
                    this.file.addClass(clazz);
                    this.currentEntity = clazz;
                }
            } else if (qName.equals("metrics")) {
                ProjectMetrics mets = this.getMetrics(atts, this.currentEntity);
                if (this.requiredLevel >= this.currentLevel) {
                    this.currentEntity.setMetrics(mets);
                }
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) {
            if (qName.equals("project")) {
                this.currentLevel = 0;
                this.seenProjectElement = true;
            } else if (qName.equals("package")) {
                this.currentLevel = 1;
                if (this.currentEntity instanceof BasePackageInfo) {
                    this.currentEntity = ((BasePackageInfo)this.currentEntity).getContainingProject();
                }
            } else if (qName.equals("file")) {
                this.currentLevel = 2;
                if (this.currentEntity instanceof BaseFileInfo) {
                    this.currentEntity = ((BaseFileInfo)this.currentEntity).getContainingPackage();
                }
            } else if (qName.equals("class")) {
                this.currentLevel = 3;
                if (this.currentEntity instanceof BaseClassInfo) {
                    this.currentEntity = ((BaseClassInfo)this.currentEntity).getContainingFile();
                }
            }
        }

        public void endDocument() {
        }

        private ProjectMetrics getMetrics(Attributes atts, HasMetrics owner) {
            String val;
            ProjectMetrics mets = new ProjectMetrics(owner);
            mets.setNumMethods(Integer.parseInt(atts.getValue("methods")));
            mets.setNumStatements(Integer.parseInt(atts.getValue("statements")));
            mets.setNumBranches(Integer.parseInt(atts.getValue("conditionals")));
            mets.setNumCoveredMethods(Integer.parseInt(atts.getValue("coveredmethods")));
            mets.setNumCoveredStatements(Integer.parseInt(atts.getValue("coveredstatements")));
            mets.setNumCoveredBranches(Integer.parseInt(atts.getValue("coveredconditionals")));
            String complexity = atts.getValue("complexity");
            if (complexity != null) {
                mets.setComplexity(Integer.parseInt(complexity));
            }
            if ((val = atts.getValue("packages")) != null) {
                mets.setNumPackages(Integer.parseInt(val));
            }
            if ((val = atts.getValue("files")) != null) {
                mets.setNumFiles(Integer.parseInt(val));
            }
            if ((val = atts.getValue("classes")) != null) {
                mets.setNumClasses(Integer.parseInt(val));
            }
            if ((val = atts.getValue("loc")) != null) {
                mets.setLineCount(Integer.parseInt(val));
            }
            if ((val = atts.getValue("ncloc")) != null) {
                mets.setNcLineCount(Integer.parseInt(val));
            }
            return mets;
        }

        private static String getAttribute(Attributes atts, String attributeName, String defaultValue) {
            String value = atts.getValue(attributeName);
            if (value == null) {
                value = defaultValue;
            }
            return value;
        }

        public CoverageDataPoint getDataPoint() {
            return this.model;
        }
    }
}

