/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.lang;

import com.atlassian.clover.Logger;
import com.atlassian.clover.services.ServiceLocator;
import com.atlassian.clover.services.ServiceNotAvailableException;
import com.atlassian.clover.spi.lang.Language;
import com.atlassian.clover.spi.lang.LanguageConstruct;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Languages {
    private static final Map<String, LanguageConstruct> LANGUAGE_CONSTRUCTS = new HashMap<String, LanguageConstruct>();
    private static final Set<Language> LANGUAGES = new HashSet<Language>();

    public static Set<Language> getLanguages() {
        return Collections.unmodifiableSet(LANGUAGES);
    }

    public static LanguageConstruct lookupConstruct(String id) {
        LanguageConstruct construct = LANGUAGE_CONSTRUCTS.get(id);
        if (construct == null) {
            throw new IllegalArgumentException("The language construct with id \"" + id + "\" could not be found.");
        }
        return construct;
    }

    static {
        for (Language.Builtin builtin : Language.Builtin.values()) {
            LANGUAGES.add(builtin);
        }
        for (Enum enum_ : LanguageConstruct.Builtin.values()) {
            LANGUAGE_CONSTRUCTS.put(((LanguageConstruct.Builtin)enum_).getId(), (LanguageConstruct)((Object)enum_));
        }
        Iterator<Language> languages = ServiceLocator.load(Language.class, Languages.class.getClassLoader()).iterator();
        while (languages.hasNext()) {
            try {
                Language language = languages.next();
                LANGUAGES.add(language);
                for (LanguageConstruct languageConstruct : language.getSupportedConstructs()) {
                    LANGUAGE_CONSTRUCTS.put(languageConstruct.getId(), languageConstruct);
                }
            }
            catch (ServiceNotAvailableException e) {
                Logger.getInstance().warn("Failed to register a 3rd party language support", e);
            }
        }
    }
}

