/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.tests.naming;

import com.atlassian.clover.api.registry.Annotation;
import com.atlassian.clover.api.registry.AnnotationValue;
import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.instr.tests.naming.TestNameExtractor;
import com.atlassian.clover.registry.entities.Modifiers;
import com.atlassian.clover.registry.entities.StringifiedAnnotationValue;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpockFeatureNameExtractor
implements TestNameExtractor {
    public static final String NAME_ATTR = "name";

    @Nullable
    public String getTestNameForMethod(@NotNull MethodInfo methodInfo) {
        Annotation featureMetadata;
        AnnotationValue attrValue;
        Collection<Annotation> featureMetadataAnnotations = methodInfo.getSignature().getModifiers().getAnnotation("org.spockframework.runtime.model.FeatureMetadata");
        if (featureMetadataAnnotations.isEmpty()) {
            featureMetadataAnnotations = methodInfo.getSignature().getModifiers().getAnnotation("FeatureMetadata");
        }
        if (!featureMetadataAnnotations.isEmpty() && (attrValue = (featureMetadata = featureMetadataAnnotations.iterator().next()).getAttribute(NAME_ATTR)) != null && attrValue instanceof StringifiedAnnotationValue) {
            return ((StringifiedAnnotationValue)attrValue).getValue();
        }
        return null;
    }

    public static boolean isClassWithSpecAnnotations(Modifiers modifiers) {
        return modifiers.containsAnnotation("org.spockframework.runtime.model.SpecMetadata") || modifiers.containsAnnotation("SpecMetadata");
    }
}

