/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import com.atlassian.clover.api.registry.MethodInfo;
import com.atlassian.clover.context.MethodRegexpContext;
import com.atlassian.clover.context.NamedContext;
import com.atlassian.clover.instr.Bindings;
import com.atlassian.clover.instr.java.Emitter;
import com.atlassian.clover.instr.java.InstrumentationState;
import com.atlassian.clover.instr.java.JavaMethodContext;
import com.atlassian.clover.instr.java.MethodRegistrationNode;
import com.atlassian.clover.registry.entities.MethodSignature;
import java.lang.reflect.Modifier;

public class MethodEntryInstrEmitter
extends Emitter {
    private MethodRegistrationNode methodNode;
    private boolean addTestInstr;
    private boolean needsFinally = false;

    public MethodEntryInstrEmitter(MethodRegistrationNode node) {
        this.methodNode = node;
    }

    protected boolean acceptsContextType(NamedContext context) {
        return context instanceof MethodRegexpContext;
    }

    public void init(InstrumentationState state) {
        this.addTestInstr = !state.getCfg().isRecordTestResults() && state.isDetectTests() && state.getTestDetector().isMethodMatch(state, JavaMethodContext.createFor(this.methodNode.getSignature()));
        StringBuffer instr = new StringBuffer();
        if (state.isInstrEnabled()) {
            state.setDirty();
            if (this.addTestInstr) {
                instr.append("try{");
                String typeInstr = "getClass().getName()";
                if (Modifier.isStatic(this.getSignature().getModifiersMask())) {
                    typeInstr = this.getMethod().getContainingClass().getName() + ".class.getName()";
                }
                instr.append(Bindings.$CoverageRecorder$globalSliceStart(state.getRecorderPrefix(), typeInstr, Integer.toString(this.methodNode.getMethod().getDataIndex()))).append(";");
                this.needsFinally = true;
            } else if (state.getCfg().isIntervalBasedFlushing()) {
                instr.append("try{");
                this.needsFinally = true;
            }
            instr.append(Bindings.$CoverageRecorder$inc(state.getRecorderPrefix(), Integer.toString(this.methodNode.getMethod().getDataIndex())));
            instr.append(";");
        }
        this.setInstr(instr.toString());
    }

    public boolean isAddTestInstr() {
        return this.addTestInstr;
    }

    public MethodSignature getSignature() {
        return this.methodNode.getSignature();
    }

    public MethodInfo getMethod() {
        return this.methodNode.getMethod();
    }

    public boolean needsFinally() {
        return this.needsFinally;
    }
}

