/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.instr.java;

import com.atlassian.clover.context.ContextSet;
import com.atlassian.clover.context.NamedContext;
import com.atlassian.clover.instr.java.InstrumentationState;
import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;

public abstract class Emitter {
    private ContextSet context = new ContextSet();
    private int line;
    private int column;
    private String instr = "";
    private boolean enabled = true;
    private List<Emitter> dependents;

    protected Emitter() {
    }

    protected Emitter(int line, int column) {
        this(new ContextSet(), line, column);
    }

    protected Emitter(ContextSet context, int line, int column) {
        this.context = context;
        this.line = line;
        this.column = column;
    }

    public ContextSet getElementContext() {
        return this.context;
    }

    public void addContext(NamedContext ctx) {
        if (this.acceptsContextType(ctx)) {
            this.context = this.context.set(ctx.getIndex());
        }
    }

    protected boolean acceptsContextType(NamedContext context) {
        return true;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        if (this.dependents != null) {
            for (Emitter kid : this.dependents) {
                kid.setEnabled(enabled);
            }
        }
    }

    public final void addDependent(Emitter emitter) {
        if (this.dependents == null) {
            this.dependents = new LinkedList<Emitter>();
        }
        emitter.setEnabled(this.isEnabled());
        this.dependents.add(emitter);
    }

    public final void emit(Writer out) throws IOException {
        if (this.isEnabled()) {
            out.write(this.getInstr());
        }
    }

    public final void initialise(InstrumentationState state) {
        this.context = this.context.or(state.getInstrContext());
        this.init(state);
    }

    protected abstract void init(InstrumentationState var1);

    public void setInstr(String instr) {
        this.instr = instr;
    }

    public String getInstr() {
        return this.instr;
    }
}

