/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ci;

import com.atlassian.clover.api.ci.CIOptions;
import com.atlassian.clover.api.ci.Integrator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenIntegrator
implements Integrator {
    static final String GROUP_ID = "com.atlassian.maven.plugins";
    static final String ARTIFACT_ID = "maven-clover2-plugin";
    static final String PREFIX = String.format("%s::%s:", "com.atlassian.maven.plugins", "maven-clover2-plugin");
    private final CIOptions options;

    public MavenIntegrator(CIOptions options) {
        this.options = options;
    }

    @Override
    public void decorateArguments(List<String> args) {
        if (this.options.isFullClean()) {
            args.add("clean");
        }
        args.add(PREFIX + "setup");
        if (this.options.isOptimize()) {
            args.add(PREFIX + "optimize");
            args.add("test");
            args.add(PREFIX + "snapshot");
        } else {
            args.add("verify");
            args.add(PREFIX + "aggregate");
            args.add(PREFIX + "clover");
            if (this.options.isHistorical()) {
                String histDir = this.options.getHistoryDir() != null ? this.options.getHistoryDir().getAbsolutePath() : ".cloverhistory";
                args.add("-Dmaven.clover.historyDir=" + histDir);
                args.add(PREFIX + "save-history");
            }
            args.add("-Dmaven.clover.generateJson=" + this.options.isJson());
        }
        if (this.options.getLicenseCert() != null && !this.options.getLicenseCert().trim().equals("")) {
            args.add("-Dmaven.clover.license=" + this.options.getLicenseCert());
        }
        if (this.options.getLicense() != null) {
            args.add("-Dmaven.clover.licenseLocation=" + this.options.getLicense().getAbsolutePath());
        }
    }
}

