/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover.ant.tasks;

import com.atlassian.clover.Logger;
import com.atlassian.clover.ant.groovy.GroovycSupport;
import com.atlassian.clover.ant.tasks.AbstractInstrTask;
import com.atlassian.clover.ant.tasks.AntInstrumentationConfig;
import com.atlassian.clover.util.ClassPathUtil;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.CloverCompilerAdapter;
import org.apache.tools.ant.types.PatternSet;

public class CloverSetupTask
extends AbstractInstrTask {
    public static final String BUILD_COMPILER = "build.compiler";

    public void setEnabled(boolean enabled) {
        this.config.setEnabled(enabled);
    }

    public void setCloverCompiler(String cloverCompiler) {
        this.config.setCompilerDelegate(cloverCompiler);
    }

    public void setPreserve(boolean preserve) {
        this.config.setPreserve(preserve);
    }

    public void setGroverJar(File groverJar) {
        this.config.setGroverJar(groverJar);
    }

    public void setSkipGroverJar(boolean skip) {
        this.config.setSkipGroverJar(skip);
    }

    public void addFiles(PatternSet filesPattern) {
        this.config.setInstrPattern(filesPattern);
    }

    public void cloverExecute() {
        try {
            AntInstrumentationConfig existingCfg = AntInstrumentationConfig.getFrom(this.getProject());
            if (existingCfg != null) {
                Logger.getInstance().debug("Existing Clover configuration found with initstring \"" + existingCfg.getInitString() + "\". Overriding.");
            }
        }
        catch (ClassCastException e) {
            Logger.getInstance().warn("Clover error: Unknown type for reference clover.config: ", e);
        }
        String existingBuildCompiler = this.getProject().getProperty(BUILD_COMPILER);
        if ("org.apache.tools.ant.taskdefs.CloverCompilerAdapter".equals(existingBuildCompiler)) {
            String cmpDelegate = this.config.getCompilerDelegate();
            this.getProject().setProperty(BUILD_COMPILER, cmpDelegate == null ? CloverCompilerAdapter.getDefaultAntCompiler() : cmpDelegate);
        }
        this.config.setIn(this.getProject());
        GroovycSupport.ensureAddedTo(this.getProject());
        if (!this.config.isEnabled()) {
            this.getProject().log("Clover is disabled.");
            return;
        }
        String runtimeInitString = this.getRuntimeInitString();
        Logger.getInstance().info("Clover is enabled with initstring '" + runtimeInitString + "'");
        String buildCompiler = this.getProject().getProperty(BUILD_COMPILER);
        if (buildCompiler != null && !buildCompiler.equals("org.apache.tools.ant.taskdefs.CloverCompilerAdapter") && this.config.getCompilerDelegate() == null) {
            this.config.setCompilerDelegate(buildCompiler);
        }
        this.getProject().setProperty(BUILD_COMPILER, "org.apache.tools.ant.taskdefs.CloverCompilerAdapter");
        this.getProject().setProperty("clover.initstring", runtimeInitString);
        if (this.config.getCompilerDelegate() != null && this.config.getCompilerDelegate().equals("org.apache.tools.ant.taskdefs.CloverCompilerAdapter")) {
            throw new BuildException("You cannot set clovercompiler to be the Clover compiler adapter. Check the value you are passing to clovercompiler, or the value of the build.compiler Ant property");
        }
        String cloverJarPath = ClassPathUtil.getCloverJarPath();
        if (cloverJarPath != null) {
            this.getProject().setProperty("clover.jarpath", cloverJarPath);
        }
    }
}

