/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.clover;

import clover.org.apache.commons.lang.StringUtils;
import com.atlassian.clover.CloverStartup;
import com.atlassian.clover.Logger;
import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.cfg.instr.MethodContextDef;
import com.atlassian.clover.cfg.instr.java.JavaInstrumentationConfig;
import com.atlassian.clover.cfg.instr.java.LambdaInstrumentation;
import com.atlassian.clover.context.ContextStore;
import com.atlassian.clover.instr.java.Instrumenter;
import com.atlassian.clover.remote.DistributedConfig;
import com.atlassian.clover.util.FileUtils;
import com.atlassian.clover.util.SourceScanner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloverInstr {
    private JavaInstrumentationConfig cfg;
    private File inDir;
    private File outDir;
    private List<String> srcFiles = new ArrayList<String>();
    private Logger log = Logger.getInstance();

    private CloverInstr() {
    }

    public static void main(String[] args) {
        System.exit(CloverInstr.mainImpl(args));
    }

    public static int mainImpl(String[] args) {
        CloverStartup.loadLicense(Logger.getInstance());
        CloverInstr instr = new CloverInstr();
        if (!instr.processArgs(args)) {
            return 1;
        }
        return instr.execute();
    }

    public int execute() {
        this.log = Logger.getInstance();
        Instrumenter instr = new Instrumenter(this.log, this.cfg);
        try {
            ContextStore.saveCustomContexts(this.cfg);
            instr.startInstrumentation();
        }
        catch (CloverException e) {
            this.log.error("Could not initialise Clover: " + e.getMessage());
            return 1;
        }
        try {
            if (this.inDir != null) {
                this.srcFiles.addAll(this.scanSrcDir(this.inDir));
            }
            for (String srcFile : this.srcFiles) {
                instr.instrument(new File(srcFile), this.outDir, this.cfg.getEncoding());
            }
            instr.endInstrumentation();
        }
        catch (Exception e) {
            this.log.error("Instrumentation error", e);
            return 1;
        }
        return 0;
    }

    private List<String> scanSrcDir(final File dir) throws IOException {
        final ArrayList<String> files = new ArrayList<String>();
        SourceScanner scanner = new SourceScanner(dir, ".*\\.java");
        scanner.visit(new SourceScanner.Visitor(){

            public void common(String path) throws IOException {
                files.add(new File(dir, FileUtils.getNormalizedPath(path)).getAbsolutePath());
            }

            public void onlyInSrc(String path) throws IOException {
                files.add(new File(dir, FileUtils.getNormalizedPath(path)).getAbsolutePath());
            }

            public void onlyInDest(String path) {
            }
        });
        return files;
    }

    private static void usage(String msg) {
        System.err.println();
        if (msg != null) {
            System.err.println("  *** ERROR: " + msg);
        }
        System.err.println();
        System.err.println("  USAGE: " + CloverInstr.class.getName() + " [OPTIONS] PARAMS [FILES...]");
        System.err.println();
        System.err.println("  PARAMS:");
        System.err.println("    -s, --srcdir <dir>\t\t Directory containing source files to be instrumented. If omitted");
        System.err.println("\t\t\t\t individual source files should be specified on the command line.");
        System.err.println();
        System.err.println("    -d, --destdir <dir>\t\t Directory where Clover should place the instrumented sources.");
        System.err.println();
        System.err.println();
        System.err.println("  OPTIONS:");
        System.err.println("    -i, --initstring <file>\t Clover initstring. This is the path to the dbfile that");
        System.err.println("\t\t\t\t will be used to construct/update to store coverage data.");
        System.err.println();
        System.err.println("    -dc, --distributedCoverage <string>\t Configuration for recording distributed pre-test coverage. ");
        System.err.println("\t\t\t\t Valid keys and default values are: ON | OFF | " + new DistributedConfig());
        System.err.println();
        System.err.println("    -r, --relative\t If specified, the initstring is treated as a relative path, ");
        System.err.println("\t\t\t\t rather than being converted to an absolute path.");
        System.err.println("\t\t\t\t This is useful for distributed testing environments.");
        System.err.println();
        System.err.println("    -p, --flushpolicy <policy>\t Set the flushpolicy Clover will use during coverage recording.");
        System.err.println("\t\t\t\t legal values are \"directed\",\"interval\",\"threaded\". Default is \"directed\". If");
        System.err.println("\t\t\t\t either \"interval\" or \"threaded\" policies is used, the flushinterval must also be set");
        System.err.println("\t\t\t\t using the -f option.");
        System.err.println("    -f, --flushinterval <int>\t Set the interval between flushes (in millisecs). Only applies to");
        System.err.println("\t\t\t\t \"interval\" or \"threaded\" flush policies.");
        System.err.println("    -e, --encoding <encoding>\t Set the File encoding to use when reading source files.");
        System.err.println();
        System.err.println("    --instrumentation <string>\t Set the instrumentation strategy. Valid values are \"field\" and");
        System.err.println("\t\t\t\t \"class\". Default is \"class\".");
        System.err.println();
        System.err.println("    --instrlevel <string>\t Set the instrumentation level. Valid values are \"statement\" and");
        System.err.println("\t\t\t\t \"method\". Default is \"statement\".");
        System.err.println();
        System.err.println("    --instrlambda <string>\t Set whether lambda functions shall be instrumented. Valid values are: " + StringUtils.join((Object[])LambdaInstrumentation.values(), ", ").toLowerCase(Locale.ENGLISH) + ".");
        System.err.println("\t\t\t\t Default is " + (Object)((Object)LambdaInstrumentation.ALL) + ".");
        System.err.println();
        System.err.println("    --source <level>\t\t Set the language level for Clover to use when parsing files.");
        System.err.println();
        System.err.println("    --recordTestResults <true|false> \t If set to false, Clover will not record test results.");
        System.err.println();
        System.err.println("    --dontFullyQualifyJavaLang \t\t If set, then java.lang will not be used in instrumented source.");
        System.err.println();
        System.err.println("    -mc --methodContext <name>=<regexp> \t\t Defines a single custom method context. May be supplied more than once. (\\ may be needed to prevent shell expansion)");
        System.err.println();
        System.err.println("    -sc --statementContext <name>=<regexp>\t\t Defines a single custom statement context. May be supplied more than once.(\\ may be needed to prevent shell expansion)");
        System.err.println();
        System.err.println("    -v, --verbose\t\t Enable verbose logging.");
    }

    private boolean processArgs(String[] args) {
        this.cfg = new JavaInstrumentationConfig();
        try {
            for (int i = 0; i < args.length; ++i) {
                String instr;
                if (args[i].equals("-i") || args[i].equals("--initstring")) {
                    this.cfg.setInitstring(args[++i]);
                    continue;
                }
                if (args[i].equals("-r") || args[i].equals("--relative")) {
                    this.cfg.setRelative(true);
                    continue;
                }
                if (args[i].equals("-s") || args[i].equals("--srcdir")) {
                    this.inDir = new File(args[++i]).getAbsoluteFile();
                    continue;
                }
                if (args[i].equals("-d") || args[i].equals("--destdir")) {
                    this.outDir = new File(args[++i]).getAbsoluteFile();
                    continue;
                }
                if (args[i].equals("-e") || args[i].equals("--encoding")) {
                    this.cfg.setEncoding(args[++i]);
                    continue;
                }
                if (args[i].equals("--recordTestResults")) {
                    this.cfg.setRecordTestResults(Boolean.valueOf(args[++i]));
                    continue;
                }
                if (args[i].equals("-dc") || args[i].equals("--distributedCoverage")) {
                    this.cfg.setDistributedConfig(new DistributedConfig(args[++i]));
                    continue;
                }
                if (args[i].equalsIgnoreCase("--dontFullyQualifyJavaLang")) {
                    this.cfg.setFullyQualifyJavaLang(false);
                    continue;
                }
                if (args[i].equals("-p") || args[i].equals("--flushpolicy")) {
                    String policy = args[++i];
                    try {
                        this.cfg.setFlushPolicyFromString(policy);
                        continue;
                    }
                    catch (CloverException e) {
                        CloverInstr.usage(e.getMessage());
                        return false;
                    }
                }
                if (args[i].equals("-f") || args[i].equals("--flushinterval")) {
                    ++i;
                    try {
                        this.cfg.setFlushInterval(Integer.parseInt(args[i]));
                        if (this.cfg.getFlushInterval() > 0) continue;
                        throw new NumberFormatException();
                    }
                    catch (NumberFormatException e) {
                        CloverInstr.usage("expecting a positive integer value for flush interval");
                        return false;
                    }
                }
                if (args[i].equals("-u") || args[i].equals("--useclass")) {
                    ++i;
                    this.log.warn("the useclass parameter has been deprecated and will be ignored.");
                    continue;
                }
                if (args[i].equals("--source")) {
                    this.cfg.setSourceLevel(args[++i]);
                    continue;
                }
                if (args[i].equals("--instrumentation")) {
                    instr = args[++i];
                    this.cfg.setInstrStrategy(instr);
                    continue;
                }
                if (args[i].equals("--instrlevel")) {
                    instr = args[++i];
                    this.cfg.setInstrLevelStrategy(instr);
                    continue;
                }
                if (args[i].equals("--instrlambda")) {
                    try {
                        this.cfg.setInstrumentLambda(LambdaInstrumentation.valueOf(args[++i].toUpperCase(Locale.ENGLISH)));
                        continue;
                    }
                    catch (IllegalArgumentException ex) {
                        CloverInstr.usage("Invalid value: " + args[i] + ". " + ex.getMessage());
                        return false;
                    }
                }
                if (args[i].equals("-v") || args[i].equals("--verbose")) {
                    Logger.setVerbose(true);
                    continue;
                }
                if (args[i].equals("-mc") || args[i].equals("--methodContext")) {
                    ++i;
                    try {
                        this.cfg.addMethodContext(this.parseContextDef(args[i]));
                        continue;
                    }
                    catch (CloverException e) {
                        CloverInstr.usage("Could not parse custom method context definition: " + args[i] + ". " + e.getMessage());
                        return false;
                    }
                }
                if (args[i].equals("-sc") || args[i].equals("--statementContext")) {
                    ++i;
                    try {
                        this.cfg.addStatementContext(this.parseContextDef(args[i]));
                        continue;
                    }
                    catch (CloverException e) {
                        CloverInstr.usage("Could not parse custom statement context definition: " + args[i] + ". " + e.getMessage());
                        return false;
                    }
                }
                if (!args[i].endsWith(".java")) continue;
                this.srcFiles.add(args[i]);
            }
            if (this.cfg.getInitString() == null) {
                try {
                    this.cfg.createDefaultInitStringDir();
                }
                catch (CloverException e) {
                    CloverInstr.usage("No --initstring value supplied, and default location could not be created: " + e.getMessage());
                    return false;
                }
            }
            if (this.inDir == null && this.srcFiles.size() == 0) {
                CloverInstr.usage("No source files specified");
                return false;
            }
            if (this.outDir == null) {
                CloverInstr.usage("No Destination dir specified");
                return false;
            }
            if ((this.cfg.getFlushPolicy() == 1 || this.cfg.getFlushPolicy() == 2) && this.cfg.getFlushInterval() == 0) {
                CloverInstr.usage("When using either \"interval\" or \"threaded\" flushpolicy, a flushinterval must be specified.");
                return false;
            }
            if (this.inDir != null) {
                if (this.inDir.equals(this.outDir)) {
                    CloverInstr.usage("Srcdir and destdir cannot be the same.");
                    return false;
                }
                for (File outParent = this.outDir.getParentFile(); outParent != null; outParent = outParent.getParentFile()) {
                    if (!outParent.equals(this.inDir)) continue;
                    CloverInstr.usage("Cannot specify a destdir that is a nested dir of the srcdir.");
                    return false;
                }
                if (this.cfg.getFlushPolicy() == 0 && this.cfg.getFlushInterval() != 0) {
                    this.log.warn("ignoring flushinterval since flushpolicy is directed. To specify interval flushing, use -p interval.");
                }
            }
            return true;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            CloverInstr.usage("Missing a parameter.");
            return false;
        }
    }

    private MethodContextDef parseContextDef(String line) throws CloverException {
        int index = line.indexOf(61);
        if (index <= 0 || index + 1 == line.length()) {
            throw new CloverException("Custom context definitions must be of the form: 'name=regexp'");
        }
        MethodContextDef contextDef = new MethodContextDef();
        contextDef.setName(line.substring(0, index));
        contextDef.setRegexp(line.substring(index + 1, line.length()));
        return contextDef;
    }
}

