/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.AbstractPriorityQueue;
import clover.it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class ObjectArrayPriorityQueue
extends AbstractPriorityQueue {
    protected Object[] array = ObjectArrays.EMPTY_ARRAY;
    protected int size;
    protected Comparator c;

    public ObjectArrayPriorityQueue(int capacity, Comparator c) {
        if (capacity > 0) {
            this.array = new Object[capacity];
        }
        this.c = c;
    }

    public ObjectArrayPriorityQueue(int capacity) {
        this(capacity, null);
    }

    public ObjectArrayPriorityQueue(Comparator c) {
        this(0, c);
    }

    public ObjectArrayPriorityQueue() {
        this(0, null);
    }

    public ObjectArrayPriorityQueue(Object[] a, int size, Comparator c) {
        this(c);
        this.array = a;
        this.size = size;
    }

    public ObjectArrayPriorityQueue(Object[] a, Comparator c) {
        this(a, a.length, c);
    }

    public ObjectArrayPriorityQueue(Object[] a, int size) {
        this(a, size, null);
    }

    public ObjectArrayPriorityQueue(Object[] a) {
        this(a, a.length);
    }

    private int findFirst() {
        int i = this.size;
        int firstIndex = --i;
        Object first = this.array[firstIndex];
        if (this.c == null) {
            while (i-- != 0) {
                if (((Comparable)this.array[i]).compareTo(first) >= 0) continue;
                firstIndex = i;
                first = this.array[firstIndex];
            }
        } else {
            while (i-- != 0) {
                if (this.c.compare(this.array[i], first) >= 0) continue;
                firstIndex = i;
                first = this.array[firstIndex];
            }
        }
        return firstIndex;
    }

    private void ensureNonEmpty() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
    }

    public void enqueue(Object x) {
        if (this.size == this.array.length) {
            this.array = ObjectArrays.grow(this.array, this.size + 1);
        }
        this.array[this.size++] = x;
    }

    public Object dequeue() {
        this.ensureNonEmpty();
        int first = this.findFirst();
        Object result = this.array[first];
        System.arraycopy(this.array, first + 1, this.array, first, --this.size - first);
        this.array[this.size] = null;
        return result;
    }

    public Object first() {
        this.ensureNonEmpty();
        return this.array[this.findFirst()];
    }

    public void changed() {
        this.ensureNonEmpty();
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        ObjectArrays.fill(this.array, 0, this.size, null);
        this.size = 0;
    }

    public void trim() {
        this.array = ObjectArrays.trim(this.array, this.size);
    }

    public Comparator comparator() {
        return this.c;
    }
}

