/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.IndirectDoublePriorityQueue;
import clover.it.unimi.dsi.fastutil.objects.ObjectArrayIndirectPriorityQueue;
import clover.it.unimi.dsi.fastutil.objects.ObjectComparators;
import java.util.Comparator;

public class ObjectArrayIndirectDoublePriorityQueue
extends ObjectArrayIndirectPriorityQueue
implements IndirectDoublePriorityQueue {
    protected Comparator secondaryComparator;

    public ObjectArrayIndirectDoublePriorityQueue(Object[] refArray, int capacity, Comparator c, Comparator d) {
        super(refArray, capacity, c);
        this.secondaryComparator = d;
    }

    public ObjectArrayIndirectDoublePriorityQueue(Object[] refArray, int capacity, Comparator c) {
        super(refArray, capacity, c == null ? ObjectComparators.OPPOSITE_COMPARATOR : ObjectComparators.oppositeComparator(c));
    }

    public ObjectArrayIndirectDoublePriorityQueue(Object[] refArray, int capacity) {
        this(refArray, capacity, null);
    }

    public ObjectArrayIndirectDoublePriorityQueue(Object[] refArray, Comparator c, Comparator d) {
        this(refArray, refArray.length, c, d);
    }

    public ObjectArrayIndirectDoublePriorityQueue(Object[] refArray, Comparator c) {
        this(refArray, refArray.length, c);
    }

    public ObjectArrayIndirectDoublePriorityQueue(Object[] refArray) {
        this(refArray, refArray.length, null);
    }

    public ObjectArrayIndirectDoublePriorityQueue(Object[] refArray, int[] a, int size, Comparator c, Comparator d) {
        this(refArray, 0, c, d);
        this.array = a;
        this.size = size;
    }

    public ObjectArrayIndirectDoublePriorityQueue(Object[] refArray, int[] a, Comparator c, Comparator d) {
        this(refArray, a, a.length, c, d);
    }

    public ObjectArrayIndirectDoublePriorityQueue(Object[] refArray, int[] a, int size, Comparator c) {
        this(refArray, 0, c);
        this.array = a;
        this.size = size;
    }

    public ObjectArrayIndirectDoublePriorityQueue(Object[] refArray, int[] a, Comparator c) {
        this(refArray, a, a.length, c);
    }

    public ObjectArrayIndirectDoublePriorityQueue(Object[] refArray, int[] a, int size) {
        this(refArray, a, size, null);
    }

    public ObjectArrayIndirectDoublePriorityQueue(Object[] refArray, int[] a) {
        this(refArray, a, a.length);
    }

    private int findSecondaryFirst() {
        int i = this.size;
        int firstIndex = --i;
        Object first = this.refArray[this.array[firstIndex]];
        if (this.secondaryComparator == null) {
            while (i-- != 0) {
                if (((Comparable)this.refArray[this.array[i]]).compareTo(first) >= 0) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.secondaryComparator.compare(this.refArray[this.array[i]], first) >= 0) continue;
                firstIndex = i;
                first = this.refArray[this.array[firstIndex]];
            }
        }
        return firstIndex;
    }

    private int findSecondaryLast() {
        int i = this.size;
        int lastIndex = --i;
        Object last = this.refArray[this.array[lastIndex]];
        if (this.secondaryComparator == null) {
            while (i-- != 0) {
                if (((Comparable)last).compareTo(this.refArray[this.array[i]]) >= 0) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        } else {
            while (i-- != 0) {
                if (this.secondaryComparator.compare(last, this.refArray[this.array[i]]) >= 0) continue;
                lastIndex = i;
                last = this.refArray[this.array[lastIndex]];
            }
        }
        return lastIndex;
    }

    public int secondaryFirst() {
        return this.array[this.findSecondaryFirst()];
    }

    public int secondaryLast() {
        return this.array[this.findSecondaryLast()];
    }

    public void changed(int i) {
    }

    public Comparator secondaryComparator() {
        return this.secondaryComparator;
    }
}

