/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.objects;

import clover.it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import clover.it.unimi.dsi.fastutil.objects.Object2BooleanSortedMap;
import clover.it.unimi.dsi.fastutil.objects.ObjectSortedSets;
import java.io.Serializable;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;

public class Object2BooleanSortedMaps {
    public static final EmptySortedMap EMPTY_MAP = new EmptySortedMap();

    private Object2BooleanSortedMaps() {
    }

    public static Object2BooleanSortedMap singleton(Object key, boolean value) {
        return new Singleton(key, value);
    }

    public static Object2BooleanSortedMap singleton(Object key, boolean value, Comparator comparator) {
        return new Singleton(key, value, comparator);
    }

    public static Object2BooleanSortedMap singleton(Object key, Object value) {
        return new Singleton(key, (Boolean)value);
    }

    public static Object2BooleanSortedMap singleton(Object key, Object value, Comparator comparator) {
        return new Singleton(key, (Boolean)value, comparator);
    }

    public static Object2BooleanSortedMap synchronize(Object2BooleanSortedMap m) {
        return new SynchronizedSortedMap(m);
    }

    public static Object2BooleanSortedMap synchronize(Object2BooleanSortedMap m, Object sync) {
        return new SynchronizedSortedMap(m, sync);
    }

    public static Object2BooleanSortedMap unmodifiable(Object2BooleanSortedMap m) {
        return new UnmodifiableSortedMap(m);
    }

    public static class UnmodifiableSortedMap
    extends Object2BooleanMaps.UnmodifiableMap
    implements Object2BooleanSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Object2BooleanSortedMap sortedMap;

        protected UnmodifiableSortedMap(Object2BooleanSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        public Comparator comparator() {
            return this.sortedMap.comparator();
        }

        public SortedMap subMap(Object from, Object to) {
            return new UnmodifiableSortedMap((Object2BooleanSortedMap)this.sortedMap.subMap(from, to));
        }

        public SortedMap headMap(Object to) {
            return new UnmodifiableSortedMap((Object2BooleanSortedMap)this.sortedMap.headMap(to));
        }

        public SortedMap tailMap(Object from) {
            return new UnmodifiableSortedMap((Object2BooleanSortedMap)this.sortedMap.tailMap(from));
        }

        public Object firstKey() {
            return this.sortedMap.firstKey();
        }

        public Object lastKey() {
            return this.sortedMap.lastKey();
        }
    }

    public static class SynchronizedSortedMap
    extends Object2BooleanMaps.SynchronizedMap
    implements Object2BooleanSortedMap,
    Serializable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Object2BooleanSortedMap sortedMap;

        protected SynchronizedSortedMap(Object2BooleanSortedMap m, Object sync) {
            super(m, sync);
            this.sortedMap = m;
        }

        protected SynchronizedSortedMap(Object2BooleanSortedMap m) {
            super(m);
            this.sortedMap = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Comparator comparator() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.comparator();
            }
        }

        public SortedMap subMap(Object from, Object to) {
            return new SynchronizedSortedMap((Object2BooleanSortedMap)this.sortedMap.subMap(from, to), this.sync);
        }

        public SortedMap headMap(Object to) {
            return new SynchronizedSortedMap((Object2BooleanSortedMap)this.sortedMap.headMap(to), this.sync);
        }

        public SortedMap tailMap(Object from) {
            return new SynchronizedSortedMap((Object2BooleanSortedMap)this.sortedMap.tailMap(from), this.sync);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object firstKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object lastKey() {
            Object object = this.sync;
            synchronized (object) {
                return this.sortedMap.lastKey();
            }
        }
    }

    public static class Singleton
    extends Object2BooleanMaps.Singleton
    implements Object2BooleanSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;
        protected final Comparator comparator;

        protected Singleton(Object key, boolean value, Comparator comparator) {
            super(key, value);
            this.comparator = comparator;
        }

        protected Singleton(Object key, boolean value) {
            this(key, value, null);
        }

        final int compare(Object k1, Object k2) {
            return this.comparator == null ? ((Comparable)k1).compareTo(k2) : this.comparator.compare(k1, k2);
        }

        public Comparator comparator() {
            return this.comparator;
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = ObjectSortedSets.singleton(this.key, this.comparator);
            }
            return this.keys;
        }

        public SortedMap subMap(Object from, Object to) {
            if (this.compare(from, this.key) <= 0 && this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public SortedMap headMap(Object to) {
            if (this.compare(this.key, to) < 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public SortedMap tailMap(Object from) {
            if (this.compare(from, this.key) <= 0) {
                return this;
            }
            return EMPTY_MAP;
        }

        public Object firstKey() {
            return this.key;
        }

        public Object lastKey() {
            return this.key;
        }
    }

    public static class EmptySortedMap
    extends Object2BooleanMaps.EmptyMap
    implements Object2BooleanSortedMap,
    Serializable,
    Cloneable {
        public static final long serialVersionUID = -7046029254386353129L;

        protected EmptySortedMap() {
        }

        public Comparator comparator() {
            return null;
        }

        public SortedMap subMap(Object from, Object to) {
            return EMPTY_MAP;
        }

        public SortedMap headMap(Object to) {
            return EMPTY_MAP;
        }

        public SortedMap tailMap(Object from) {
            return EMPTY_MAP;
        }

        public Object firstKey() {
            throw new NoSuchElementException();
        }

        public Object lastKey() {
            throw new NoSuchElementException();
        }
    }
}

