/*
 * Decompiled with CFR 0.152.
 */
package clover.it.unimi.dsi.fastutil.bytes;

import clover.it.unimi.dsi.fastutil.bytes.AbstractByteIterator;
import clover.it.unimi.dsi.fastutil.bytes.AbstractByteSet;
import clover.it.unimi.dsi.fastutil.bytes.Byte2CharMap;
import clover.it.unimi.dsi.fastutil.bytes.ByteIterator;
import clover.it.unimi.dsi.fastutil.bytes.ByteSet;
import clover.it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import clover.it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import clover.it.unimi.dsi.fastutil.chars.CharCollection;
import clover.it.unimi.dsi.fastutil.chars.CharIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class AbstractByte2CharMap
implements Byte2CharMap,
Serializable {
    protected char defRetValue;

    protected AbstractByte2CharMap() {
    }

    public void setDefRetValue(char rv) {
        this.defaultReturnValue(rv);
    }

    public char getDefRetValue() {
        return this.defaultReturnValue();
    }

    public void defaultReturnValue(char rv) {
        this.defRetValue = rv;
    }

    public char defaultReturnValue() {
        return this.defRetValue;
    }

    public char put(byte key, char value) {
        throw new UnsupportedOperationException();
    }

    public char remove(byte key) {
        throw new UnsupportedOperationException();
    }

    public void clear() {
        throw new UnsupportedOperationException();
    }

    public Object get(Object ok) {
        byte k = (Byte)ok;
        return this.containsKey(k) ? new Character(this.get(k)) : null;
    }

    public Object put(Object ok, Object ov) {
        byte k = (Byte)ok;
        char v = this.put(k, ((Character)ov).charValue());
        return this.containsKey(k) ? new Character(v) : null;
    }

    public Object remove(Object ok) {
        byte k = (Byte)ok;
        char v = this.remove(k);
        return this.containsKey(k) ? new Character(v) : null;
    }

    public boolean containsValue(Object ov) {
        return this.containsValue(((Character)ov).charValue());
    }

    public boolean containsKey(Object ok) {
        return this.containsKey((Byte)ok);
    }

    public boolean containsValue(char v) {
        return ((CharCollection)this.values()).contains(v);
    }

    public boolean containsKey(byte k) {
        return ((ByteSet)this.keySet()).contains(k);
    }

    public void putAll(Map m) {
        int n = m.size();
        Iterator i = m.entrySet().iterator();
        if (m instanceof Byte2CharMap) {
            while (n-- != 0) {
                Byte2CharMap.Entry e = (Byte2CharMap.Entry)i.next();
                this.put(e.getByteKey(), e.getCharValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set keySet() {
        return new AbstractByteSet(){

            public boolean contains(byte k) {
                return AbstractByte2CharMap.this.containsKey(k);
            }

            public int size() {
                return AbstractByte2CharMap.this.size();
            }

            public ByteIterator byteIterator() {
                return new AbstractByteIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractByte2CharMap.this.entrySet().iterator();
                    }

                    public byte nextByte() {
                        return ((Byte2CharMap.Entry)this.i.next()).getByteKey();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public Collection values() {
        return new AbstractCharCollection(){

            public boolean contains(char k) {
                return AbstractByte2CharMap.this.containsValue(k);
            }

            public int size() {
                return AbstractByte2CharMap.this.size();
            }

            public CharIterator charIterator() {
                return new AbstractCharIterator(){
                    final Iterator i;
                    {
                        this.i = AbstractByte2CharMap.this.entrySet().iterator();
                    }

                    public char nextChar() {
                        return ((Byte2CharMap.Entry)this.i.next()).getCharValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    public int hashCode() {
        int h = 0;
        int n = this.size();
        Iterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        Iterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Byte2CharMap.Entry e = (Byte2CharMap.Entry)i.next();
            s.append(String.valueOf(e.getByteKey()));
            s.append("=>");
            s.append(String.valueOf(e.getCharValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static class BasicEntry
    implements Byte2CharMap.Entry {
        protected byte key;
        protected char value;

        public BasicEntry(Object key, Object value) {
            this.key = (Byte)key;
            this.value = ((Character)value).charValue();
        }

        public BasicEntry(byte key, char value) {
            this.key = key;
            this.value = value;
        }

        public Object getKey() {
            return new Byte(this.key);
        }

        public byte getByteKey() {
            return this.key;
        }

        public Object getValue() {
            return new Character(this.value);
        }

        public char getCharValue() {
            return this.value;
        }

        public char setValue(char value) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object value) {
            return new Character(this.setValue(((Character)value).charValue()));
        }

        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == (Byte)e.getKey() && this.value == ((Character)e.getValue()).charValue();
        }

        public int hashCode() {
            return this.key ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

