/*
 * Decompiled with CFR 0.152.
 */
package clover.com.lowagie.text.pdf;

import clover.com.lowagie.text.ExceptionConverter;
import clover.com.lowagie.text.Rectangle;
import clover.com.lowagie.text.pdf.Barcode;
import clover.com.lowagie.text.pdf.BaseFont;
import clover.com.lowagie.text.pdf.PdfContentByte;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;

public class BarcodeInter25
extends Barcode {
    private static final byte[][] BARS;

    static {
        byte[][] byArrayArray = new byte[10][];
        byte[] byArray = new byte[5];
        byArray[2] = 1;
        byArray[3] = 1;
        byArrayArray[0] = byArray;
        byte[] byArray2 = new byte[5];
        byArray2[0] = 1;
        byArray2[4] = 1;
        byArrayArray[1] = byArray2;
        byte[] byArray3 = new byte[5];
        byArray3[1] = 1;
        byArray3[4] = 1;
        byArrayArray[2] = byArray3;
        byte[] byArray4 = new byte[5];
        byArray4[0] = 1;
        byArray4[1] = 1;
        byArrayArray[3] = byArray4;
        byte[] byArray5 = new byte[5];
        byArray5[2] = 1;
        byArray5[4] = 1;
        byArrayArray[4] = byArray5;
        byte[] byArray6 = new byte[5];
        byArray6[0] = 1;
        byArray6[2] = 1;
        byArrayArray[5] = byArray6;
        byte[] byArray7 = new byte[5];
        byArray7[1] = 1;
        byArray7[2] = 1;
        byArrayArray[6] = byArray7;
        byte[] byArray8 = new byte[5];
        byArray8[3] = 1;
        byArray8[4] = 1;
        byArrayArray[7] = byArray8;
        byte[] byArray9 = new byte[5];
        byArray9[0] = 1;
        byArray9[3] = 1;
        byArrayArray[8] = byArray9;
        byte[] byArray10 = new byte[5];
        byArray10[1] = 1;
        byArray10[3] = 1;
        byArrayArray[9] = byArray10;
        BARS = byArrayArray;
    }

    public BarcodeInter25() {
        try {
            this.x = 0.8f;
            this.n = 2.0f;
            this.font = BaseFont.createFont("Helvetica", "winansi", false);
            this.baseline = this.size = 8.0f;
            this.barHeight = this.size * 3.0f;
            this.textAlignment = 1;
            this.generateChecksum = false;
            this.checksumText = false;
        }
        catch (Exception e) {
            throw new ExceptionConverter(e);
        }
    }

    public static String keepNumbers(String text) {
        StringBuffer sb = new StringBuffer();
        int k = 0;
        while (k < text.length()) {
            char c = text.charAt(k);
            if (c >= '0' && c <= '9') {
                sb.append(c);
            }
            ++k;
        }
        return sb.toString();
    }

    public static char getChecksum(String text) {
        int mul = 3;
        int total = 0;
        int k = text.length() - 1;
        while (k >= 0) {
            int n = text.charAt(k) - 48;
            total += mul * n;
            mul ^= 2;
            --k;
        }
        return (char)((10 - total % 10) % 10 + 48);
    }

    public static byte[] getBarsInter25(String text) {
        if (((text = BarcodeInter25.keepNumbers(text)).length() & 1) != 0) {
            throw new IllegalArgumentException("The text length must be even.");
        }
        byte[] bars = new byte[text.length() * 5 + 7];
        int pb = 0;
        bars[pb++] = 0;
        bars[pb++] = 0;
        bars[pb++] = 0;
        bars[pb++] = 0;
        int len = text.length() / 2;
        int k = 0;
        while (k < len) {
            int c1 = text.charAt(k * 2) - 48;
            int c2 = text.charAt(k * 2 + 1) - 48;
            byte[] b1 = BARS[c1];
            byte[] b2 = BARS[c2];
            int j = 0;
            while (j < 5) {
                bars[pb++] = b1[j];
                bars[pb++] = b2[j];
                ++j;
            }
            ++k;
        }
        bars[pb++] = 1;
        bars[pb++] = 0;
        bars[pb++] = 0;
        return bars;
    }

    public Rectangle getBarcodeSize() {
        String fullCode;
        float fontX = 0.0f;
        float fontY = 0.0f;
        if (this.font != null) {
            fontY = this.baseline > 0.0f ? this.baseline - this.font.getFontDescriptor(3, this.size) : -this.baseline + this.size;
            fullCode = this.code;
            if (this.generateChecksum && this.checksumText) {
                fullCode = String.valueOf(fullCode) + BarcodeInter25.getChecksum(fullCode);
            }
            fontX = this.font.getWidthPoint(this.altText != null ? this.altText : fullCode, this.size);
        }
        fullCode = BarcodeInter25.keepNumbers(this.code);
        int len = fullCode.length();
        if (this.generateChecksum) {
            ++len;
        }
        float fullWidth = (float)len * (3.0f * this.x + 2.0f * this.x * this.n) + (6.0f + this.n) * this.x;
        fullWidth = Math.max(fullWidth, fontX);
        float fullHeight = this.barHeight + fontY;
        return new Rectangle(fullWidth, fullHeight);
    }

    public Rectangle placeBarcode(PdfContentByte cb, Color barColor, Color textColor) {
        String fullCode = this.code;
        float fontX = 0.0f;
        if (this.font != null) {
            if (this.generateChecksum && this.checksumText) {
                fullCode = String.valueOf(fullCode) + BarcodeInter25.getChecksum(fullCode);
            }
            fullCode = this.altText != null ? this.altText : fullCode;
            fontX = this.font.getWidthPoint(fullCode, this.size);
        }
        String bCode = BarcodeInter25.keepNumbers(this.code);
        if (this.generateChecksum) {
            bCode = String.valueOf(bCode) + BarcodeInter25.getChecksum(bCode);
        }
        int len = bCode.length();
        float fullWidth = (float)len * (3.0f * this.x + 2.0f * this.x * this.n) + (6.0f + this.n) * this.x;
        float barStartX = 0.0f;
        float textStartX = 0.0f;
        switch (this.textAlignment) {
            case 0: {
                break;
            }
            case 2: {
                if (fontX > fullWidth) {
                    barStartX = fontX - fullWidth;
                    break;
                }
                textStartX = fullWidth - fontX;
                break;
            }
            default: {
                if (fontX > fullWidth) {
                    barStartX = (fontX - fullWidth) / 2.0f;
                    break;
                }
                textStartX = (fullWidth - fontX) / 2.0f;
            }
        }
        float barStartY = 0.0f;
        float textStartY = 0.0f;
        if (this.font != null) {
            if (this.baseline <= 0.0f) {
                textStartY = this.barHeight - this.baseline;
            } else {
                textStartY = -this.font.getFontDescriptor(3, this.size);
                barStartY = textStartY + this.baseline;
            }
        }
        byte[] bars = BarcodeInter25.getBarsInter25(bCode);
        boolean print = true;
        if (barColor != null) {
            cb.setColorFill(barColor);
        }
        int k = 0;
        while (k < bars.length) {
            float w;
            float f = w = bars[k] == 0 ? this.x : this.x * this.n;
            if (print) {
                cb.rectangle(barStartX, barStartY, w - this.inkSpreading, this.barHeight);
            }
            print = !print;
            barStartX += w;
            ++k;
        }
        cb.fill();
        if (this.font != null) {
            if (textColor != null) {
                cb.setColorFill(textColor);
            }
            cb.beginText();
            cb.setFontAndSize(this.font, this.size);
            cb.setTextMatrix(textStartX, textStartY);
            cb.showText(fullCode);
            cb.endText();
        }
        return this.getBarcodeSize();
    }

    public Image createAwtImage(Color foreground, Color background) {
        int f = foreground.getRGB();
        int g = background.getRGB();
        Canvas canvas = new Canvas();
        String bCode = BarcodeInter25.keepNumbers(this.code);
        if (this.generateChecksum) {
            bCode = String.valueOf(bCode) + BarcodeInter25.getChecksum(bCode);
        }
        int len = bCode.length();
        int nn = (int)this.n;
        int fullWidth = len * (3 + 2 * nn) + (6 + nn);
        byte[] bars = BarcodeInter25.getBarsInter25(bCode);
        boolean print = true;
        int ptr = 0;
        int height = (int)this.barHeight;
        int[] pix = new int[fullWidth * height];
        int k = 0;
        while (k < bars.length) {
            int w = bars[k] == 0 ? 1 : nn;
            int c = g;
            if (print) {
                c = f;
            }
            print = !print;
            int j = 0;
            while (j < w) {
                pix[ptr++] = c;
                ++j;
            }
            ++k;
        }
        k = fullWidth;
        while (k < pix.length) {
            System.arraycopy(pix, 0, pix, k, fullWidth);
            k += fullWidth;
        }
        Image img = canvas.createImage(new MemoryImageSource(fullWidth, height, pix, 0, fullWidth));
        return img;
    }
}

