/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.ExclusionStrategy;
import clover.com.google.gson.Preconditions;
import clover.com.google.gson.annotations.Since;
import clover.com.google.gson.annotations.Until;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class VersionExclusionStrategy
implements ExclusionStrategy {
    private final double version;

    public VersionExclusionStrategy(double version) {
        Preconditions.checkArgument(version >= 0.0);
        this.version = version;
    }

    @Override
    public boolean shouldSkipField(Field f) {
        return !this.isValidVersion(f.getAnnotations());
    }

    @Override
    public boolean shouldSkipClass(Class<?> clazz) {
        return !this.isValidVersion(clazz.getAnnotations());
    }

    private boolean isValidVersion(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (this.isValidSince(annotation) && this.isValidUntil(annotation)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidSince(Annotation annotation) {
        double annotationVersion;
        return !(annotation instanceof Since) || !((annotationVersion = ((Since)annotation).value()) > this.version);
    }

    private boolean isValidUntil(Annotation annotation) {
        double annotationVersion;
        return !(annotation instanceof Until) || !((annotationVersion = ((Until)annotation).value()) <= this.version);
    }
}

