/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.gson;

import clover.com.google.gson.JsonArray;
import clover.com.google.gson.JsonDeserializationContext;
import clover.com.google.gson.JsonDeserializationVisitor;
import clover.com.google.gson.JsonDeserializer;
import clover.com.google.gson.JsonElement;
import clover.com.google.gson.JsonObject;
import clover.com.google.gson.JsonParseException;
import clover.com.google.gson.JsonPrimitive;
import clover.com.google.gson.ObjectConstructor;
import clover.com.google.gson.ObjectNavigatorFactory;
import clover.com.google.gson.ParameterizedTypeHandlerMap;
import clover.com.google.gson.TypeInfo;
import clover.com.google.gson.TypeInfoArray;
import clover.com.google.gson.TypeInfoFactory;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JsonArrayDeserializationVisitor<T>
extends JsonDeserializationVisitor<T> {
    JsonArrayDeserializationVisitor(JsonArray jsonArray, Type arrayType, ObjectNavigatorFactory factory, ObjectConstructor objectConstructor, ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers, JsonDeserializationContext context) {
        super(jsonArray, arrayType, factory, objectConstructor, deserializers, context);
    }

    @Override
    protected T constructTarget() {
        TypeInfo typeInfo = new TypeInfo(this.targetType);
        if (!this.json.isJsonArray()) {
            throw new JsonParseException("Expecting array found: " + this.json);
        }
        JsonArray jsonArray = this.json.getAsJsonArray();
        if (typeInfo.isArray()) {
            TypeInfoArray arrayTypeInfo = TypeInfoFactory.getTypeInfoForArray(this.targetType);
            return (T)this.objectConstructor.constructArray(arrayTypeInfo.getSecondLevelType(), jsonArray.size());
        }
        return this.objectConstructor.construct(typeInfo.getRawClass());
    }

    @Override
    public void visitArray(Object array, Type arrayType) {
        if (!this.json.isJsonArray()) {
            throw new JsonParseException("Expecting array found: " + this.json);
        }
        JsonArray jsonArray = this.json.getAsJsonArray();
        TypeInfoArray arrayTypeInfo = TypeInfoFactory.getTypeInfoForArray(arrayType);
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object child;
            JsonElement jsonChild = jsonArray.get(i);
            if (jsonChild == null || jsonChild.isJsonNull()) {
                child = null;
            } else if (jsonChild instanceof JsonObject) {
                child = this.visitChildAsObject(arrayTypeInfo.getComponentRawType(), jsonChild);
            } else if (jsonChild instanceof JsonArray) {
                child = this.visitChildAsArray(arrayTypeInfo.getSecondLevelType(), jsonChild.getAsJsonArray());
            } else if (jsonChild instanceof JsonPrimitive) {
                child = this.visitChildAsObject(arrayTypeInfo.getComponentRawType(), jsonChild.getAsJsonPrimitive());
            } else {
                throw new IllegalStateException();
            }
            Array.set(array, i, child);
        }
    }

    @Override
    public void startVisitingObject(Object node) {
        throw new JsonParseException("Expecting array but found object: " + node);
    }

    @Override
    public void visitArrayField(Field f, Type typeOfF, Object obj) {
        throw new JsonParseException("Expecting array but found array field " + f.getName() + ": " + obj);
    }

    @Override
    public void visitObjectField(Field f, Type typeOfF, Object obj) {
        throw new JsonParseException("Expecting array but found object field " + f.getName() + ": " + obj);
    }

    @Override
    public boolean visitFieldUsingCustomHandler(Field f, Type actualTypeOfField, Object parent) {
        throw new JsonParseException("Expecting array but found field " + f.getName() + ": " + parent);
    }
}

