/*
 * Decompiled with CFR 0.152.
 */
package clover.com.google.common.io;

import clover.com.google.common.base.Preconditions;
import com.google.common.annotations.Beta;
import java.io.File;
import java.io.FilenameFilter;
import java.util.regex.Pattern;

@Beta
public final class PatternFilenameFilter
implements FilenameFilter {
    private final Pattern pattern;

    public PatternFilenameFilter(String patternStr) {
        this(Pattern.compile(patternStr));
    }

    public PatternFilenameFilter(Pattern pattern) {
        this.pattern = Preconditions.checkNotNull(pattern);
    }

    public boolean accept(File dir, String fileName) {
        return this.pattern.matcher(fileName).matches();
    }
}

