/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test;

import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.test.io.IOResourceSet;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.test.util.RecordingToolkit;
import org.openjdk.jmc.flightrecorder.test.util.StacktraceTestToolkit;

public class StacktraceModelBaselineTest {
    @Test
    public void testAgainstBaseline() throws IOException, CouldNotLoadRecordingException {
        for (IOResourceSet resourceSet : StacktraceTestToolkit.getTestResources()) {
            String recordingName = resourceSet.getResource(0).getName();
            IItemCollection items = RecordingToolkit.getFlightRecording(resourceSet);
            List<String> parsedEvents = StacktraceTestToolkit.getAggregatedStacktraceLines(items);
            try {
                List<String> expectedStacktraces = StacktraceTestToolkit.getStacktracesBaseline(resourceSet);
                Assert.assertEquals((String)(recordingName + ": number of stack frame lines did not match expected"), (long)expectedStacktraces.size(), (long)parsedEvents.size());
                for (int i = 0; i < expectedStacktraces.size(); ++i) {
                    Assert.assertEquals((String)(recordingName + ": stack frame " + i + " did not match expected"), (Object)expectedStacktraces.get(i), (Object)parsedEvents.get(i));
                }
            }
            catch (Exception e) {
                Assert.fail((String)(recordingName + ": could not read baseline stack traces: " + e.getMessage()));
            }
        }
    }
}

