/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.openjdk.jmc.common.item.Aggregators;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.item.IItemIterable;
import org.openjdk.jmc.common.item.ItemFilters;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.flightrecorder.CouldNotLoadRecordingException;
import org.openjdk.jmc.flightrecorder.JfrAttributes;
import org.openjdk.jmc.flightrecorder.test.util.RecordingToolkit;
import org.openjdk.jmc.flightrecorder.util.ChunkReader;

public final class MetadataEventLocationUpdateTest {
    private static final int CHUNK_COUNT_FLUSH_RECORDINGS = 2;
    private static final int CHUNK_COUNT_METADATA_RECORDINGS = 1;
    private static final String[] TYPES_TO_CHECK = new String[]{"jdk.GCPhaseParallel", "jdk.CompilerInlining"};
    private static final String[] TYPES_TO_CHECK_FLUSH = new String[]{"jdk.ModuleExport", "jdk.BooleanFlag", "jdk.JavaMonitorWait"};
    private static final long[] EXPECTED_COUNTS_CONTROL = new long[]{12584L, 7283L};
    private static final long[] EXPECTED_COUNTS_NEW = new long[]{27738L, 6883L};
    private static final long[] EXPECTED_COUNTS_FLUSH_CONTROL = new long[]{1512L, 1500L, 991L};
    private static final long[] EXPECTED_COUNTS_FLUSH_INCREMENTAL = new long[]{1512L, 1500L, 860L};
    private static final int EXPECTED_NUMBER_OF_TYPES_FLUSH_RECORDINGS = 133;
    private static final String RECORDING_METADATA_CONTROL = "metadata_control.jfr";
    private static final String RECORDING_METADATA_NEW = "metadata_new.jfr";
    private static final String RECORDING_FLUSH_METADATA = "flush_metadata.jfr";
    private static final String RECORDING_FLUSH_INCREMENTAL_METADATA = "flush_incremental_metadata.jfr";

    @Test
    public void testChunkSplitter() throws IOException, CouldNotLoadRecordingException {
        int controlFlushChunkCount = MetadataEventLocationUpdateTest.countChunks(ChunkReader.readChunks((InputStream)RecordingToolkit.getNamedRecordingResource(RECORDING_FLUSH_INCREMENTAL_METADATA)));
        int incrementalFlushChunkCount = MetadataEventLocationUpdateTest.countChunks(ChunkReader.readChunks((InputStream)RecordingToolkit.getNamedRecordingResource(RECORDING_FLUSH_INCREMENTAL_METADATA)));
        int controlMetadataChunkCount = MetadataEventLocationUpdateTest.countChunks(ChunkReader.readChunks((InputStream)RecordingToolkit.getNamedRecordingResource(RECORDING_METADATA_CONTROL)));
        int newMetadataChunkCount = MetadataEventLocationUpdateTest.countChunks(ChunkReader.readChunks((InputStream)RecordingToolkit.getNamedRecordingResource(RECORDING_METADATA_NEW)));
        Assert.assertEquals((long)2L, (long)controlFlushChunkCount);
        Assert.assertEquals((long)2L, (long)incrementalFlushChunkCount);
        Assert.assertEquals((long)1L, (long)controlMetadataChunkCount);
        Assert.assertEquals((long)1L, (long)newMetadataChunkCount);
    }

    @Test
    public void testGetEventTypes() throws IOException, CouldNotLoadRecordingException {
        IItemCollection controlEvents = RecordingToolkit.getNamedRecording(RECORDING_METADATA_CONTROL);
        IItemCollection newEvents = RecordingToolkit.getNamedRecording(RECORDING_METADATA_NEW);
        IAggregator distinctTypesAggregator = Aggregators.distinct((IAttribute)JfrAttributes.EVENT_TYPE_ID);
        Set controlTypes = (Set)controlEvents.getAggregate(distinctTypesAggregator);
        Set newTypes = (Set)newEvents.getAggregate(distinctTypesAggregator);
        newTypes.removeAll(controlTypes);
        Assert.assertTrue((boolean)newTypes.contains("jdk.Flush"));
        Assert.assertEquals((long)1L, (long)newTypes.size());
    }

    @Test
    public void testCountsInRecordings() throws IOException, CouldNotLoadRecordingException {
        IItemCollection controlEvents = RecordingToolkit.getNamedRecording(RECORDING_METADATA_CONTROL);
        IItemCollection newEvents = RecordingToolkit.getNamedRecording(RECORDING_METADATA_NEW);
        for (int i = 0; i < TYPES_TO_CHECK.length; ++i) {
            String typeId = TYPES_TO_CHECK[i];
            long countControl = ((IQuantity)controlEvents.apply(ItemFilters.type((String)typeId)).getAggregate(Aggregators.count())).longValue();
            long countNew = ((IQuantity)newEvents.apply(ItemFilters.type((String)typeId)).getAggregate(Aggregators.count())).longValue();
            Assert.assertEquals((long)EXPECTED_COUNTS_CONTROL[i], (long)countControl);
            Assert.assertEquals((long)EXPECTED_COUNTS_NEW[i], (long)countNew);
        }
    }

    @Test
    public void testCountsInFlushRecordings() throws IOException, CouldNotLoadRecordingException {
        IItemCollection controlFlushEvents = RecordingToolkit.getNamedRecording(RECORDING_FLUSH_METADATA);
        IItemCollection incrementalFlushEvents = RecordingToolkit.getNamedRecording(RECORDING_FLUSH_INCREMENTAL_METADATA);
        for (int i = 0; i < TYPES_TO_CHECK_FLUSH.length; ++i) {
            String typeId = TYPES_TO_CHECK_FLUSH[i];
            long countControl = ((IQuantity)controlFlushEvents.apply(ItemFilters.type((String)typeId)).getAggregate(Aggregators.count())).longValue();
            long countNew = ((IQuantity)incrementalFlushEvents.apply(ItemFilters.type((String)typeId)).getAggregate(Aggregators.count())).longValue();
            Assert.assertEquals((long)EXPECTED_COUNTS_FLUSH_CONTROL[i], (long)countControl);
            Assert.assertEquals((long)EXPECTED_COUNTS_FLUSH_INCREMENTAL[i], (long)countNew);
        }
    }

    @Test
    public void testIncrementalMetadataTypeCounts() throws IOException, CouldNotLoadRecordingException {
        IItemCollection controlEvents = RecordingToolkit.getNamedRecording(RECORDING_FLUSH_METADATA);
        IItemCollection incremetalMetadataEvents = RecordingToolkit.getNamedRecording(RECORDING_FLUSH_INCREMENTAL_METADATA);
        Set<String> controlTypes = MetadataEventLocationUpdateTest.getKnownTypes(controlEvents);
        Set<String> incrementalTypes = MetadataEventLocationUpdateTest.getKnownTypes(incremetalMetadataEvents);
        Assert.assertEquals((long)133L, (long)controlTypes.size());
        Assert.assertEquals((long)133L, (long)incrementalTypes.size());
    }

    private static int countChunks(Iterator<byte[]> readChunks) {
        int count = 0;
        while (readChunks.hasNext()) {
            readChunks.next();
            ++count;
        }
        return count;
    }

    private static Set<String> getKnownTypes(IItemCollection items) {
        HashSet<String> types = new HashSet<String>();
        Iterator iterable = items.iterator();
        while (iterable.hasNext()) {
            types.add(((IItemIterable)iterable.next()).getType().getIdentifier());
        }
        return types;
    }
}

