/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.test.unit;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openjdk.jmc.common.test.MCTestCase;
import org.openjdk.jmc.common.unit.DecimalScaleFactor;
import org.openjdk.jmc.common.unit.IScalarAffineTransform;
import org.openjdk.jmc.common.unit.SimpleAffineTransform;

public class AffineTransformTest
extends MCTestCase {
    private IScalarAffineTransform milliCelsiusToCelsius;
    private IScalarAffineTransform celsiusToKelvin;
    private IScalarAffineTransform kelvinToCelsius;
    private IScalarAffineTransform celsiusToFahrenheit;
    private IScalarAffineTransform fahrenheitToCelsius;

    @Before
    public void setUp() throws Exception {
        this.milliCelsiusToCelsius = DecimalScaleFactor.get((int)-3);
        this.celsiusToKelvin = new SimpleAffineTransform(1.0, 273.15);
        this.kelvinToCelsius = this.celsiusToKelvin.invert();
        this.celsiusToFahrenheit = new SimpleAffineTransform(1.8, 32.0);
        this.fahrenheitToCelsius = this.celsiusToFahrenheit.invert();
    }

    private static void assertTransform(double expectedValue, IScalarAffineTransform transform, double sourceValue) {
        double ulp = Math.ulp(expectedValue);
        Assert.assertEquals((double)expectedValue, (double)transform.targetValue(sourceValue), (double)ulp);
    }

    @Test
    public void testOffsetTransform() {
        AffineTransformTest.assertTransform(298.15, this.celsiusToKelvin, 25.0);
        AffineTransformTest.assertTransform(373.15, this.celsiusToKelvin, 100.0);
    }

    @Test
    public void testInverseOffsetTransform() {
        AffineTransformTest.assertTransform(25.0, this.kelvinToCelsius, 298.15);
        AffineTransformTest.assertTransform(100.0, this.kelvinToCelsius, 373.15);
    }

    @Test
    public void testAffineTransform() {
        AffineTransformTest.assertTransform(32.0, this.celsiusToFahrenheit, 0.0);
        AffineTransformTest.assertTransform(98.6, this.celsiusToFahrenheit, 37.0);
        AffineTransformTest.assertTransform(100.0, this.celsiusToFahrenheit, 37.77777777777778);
    }

    @Test
    public void testInverseAffineTransform() {
        AffineTransformTest.assertTransform(0.0, this.fahrenheitToCelsius, 32.0);
        AffineTransformTest.assertTransform(37.0, this.fahrenheitToCelsius, 98.6);
        AffineTransformTest.assertTransform(37.77777777777778, this.fahrenheitToCelsius, 100.0);
    }

    @Test
    public void testConcatTransform() {
        IScalarAffineTransform fahrenheitToKelvin = this.celsiusToKelvin.concat(this.fahrenheitToCelsius);
        AffineTransformTest.assertTransform(273.15, fahrenheitToKelvin, 32.0);
        AffineTransformTest.assertTransform(310.15, fahrenheitToKelvin, 98.6);
        IScalarAffineTransform milliCelsiusToKelvin = this.celsiusToKelvin.concat(this.milliCelsiusToCelsius);
        AffineTransformTest.assertTransform(273.157, milliCelsiusToKelvin, 7.0);
    }

    @Test
    public void testInvertAndConcatTransform() {
        IScalarAffineTransform fahrenheitToKelvin = this.kelvinToCelsius.invertAndConcat(this.fahrenheitToCelsius);
        AffineTransformTest.assertTransform(273.15, fahrenheitToKelvin, 32.0);
        AffineTransformTest.assertTransform(310.15, fahrenheitToKelvin, 98.6);
        IScalarAffineTransform milliCelsiusToKelvin = this.kelvinToCelsius.invertAndConcat(this.milliCelsiusToCelsius);
        AffineTransformTest.assertTransform(273.157, milliCelsiusToKelvin, 7.0);
        IScalarAffineTransform kelvinToMilliCelsius = this.milliCelsiusToCelsius.invertAndConcat(this.kelvinToCelsius);
        AffineTransformTest.assertTransform(7.0, kelvinToMilliCelsius, 273.157);
    }
}

