/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.test.mock.item;

import java.text.NumberFormat;
import java.util.Random;
import org.openjdk.jmc.common.IMCStackTrace;
import org.openjdk.jmc.common.item.IItemCollection;
import org.openjdk.jmc.common.test.mock.item.MockItemCollection;
import org.openjdk.jmc.common.test.mock.item.MockNumberType;
import org.openjdk.jmc.common.test.mock.item.MockStacktraceType;

public class MockCollections {
    public static IItemCollection getNumberCollection(Number[] values) {
        return new MockItemCollection(values, new MockNumberType());
    }

    public static Number[] generateNumberArray(int n, double x) {
        Number[] array = new Number[n];
        Random RND = new Random(4711L);
        for (int i = 0; i < array.length; ++i) {
            array[i] = RND.nextDouble() * x;
        }
        return array;
    }

    public static String generateFullPrecisionString(Number[] values) {
        NumberFormat formatter = NumberFormat.getInstance();
        formatter.setMaximumFractionDigits(340);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            builder.append(formatter.format(values[i]));
            builder.append("\n");
        }
        return builder.toString();
    }

    public static IItemCollection getStackTraceCollection(IMCStackTrace[] traces) {
        return new MockItemCollection(traces, new MockStacktraceType());
    }

    public static void main(String[] args) {
        System.out.println(MockCollections.generateFullPrecisionString(MockCollections.generateNumberArray(5, 5.0)));
    }
}

