/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.test.unit;

import org.junit.Before;
import org.junit.Test;
import org.openjdk.jmc.common.test.MCTestCase;
import org.openjdk.jmc.common.test.unit.AdHocQuantityTest;
import org.openjdk.jmc.common.unit.BinaryPrefix;
import org.openjdk.jmc.common.unit.IPrefix;
import org.openjdk.jmc.common.unit.IQuantity;
import org.openjdk.jmc.common.unit.IRange;
import org.openjdk.jmc.common.unit.ITypedQuantity;
import org.openjdk.jmc.common.unit.IUnit;
import org.openjdk.jmc.common.unit.KindOfQuantity;
import org.openjdk.jmc.common.unit.LinearKindOfQuantity;
import org.openjdk.jmc.common.unit.LinearUnit;
import org.openjdk.jmc.common.unit.UnitLookup;

public class TickMarksTest
extends MCTestCase {
    private LinearUnit one;
    private LinearUnit B;
    private LinearUnit kiB;
    private LinearUnit s;
    private LinearUnit min;
    private LinearUnit h;
    private LinearUnit d;
    private LinearUnit wk;
    private LinearUnit y;

    @Before
    public void setUp() throws Exception {
        this.one = UnitLookup.NUMBER_UNITY;
        this.B = UnitLookup.BYTE;
        this.kiB = UnitLookup.MEMORY.getUnit((IPrefix)BinaryPrefix.KIBI);
        LinearKindOfQuantity span = UnitLookup.TIMESPAN;
        this.s = UnitLookup.SECOND;
        this.min = UnitLookup.MINUTE;
        this.h = span.getUnit("h");
        this.d = span.getUnit("d");
        this.wk = span.getUnit("wk");
        this.y = span.getUnit("a");
    }

    private void assertTicks(ITypedQuantity<LinearUnit> expectedSpacing, IQuantity expectedAlignedStart, IQuantity start, IQuantity end, int maxTicks) throws Exception {
        KindOfQuantity kind = start.getType();
        IRange firstBucket = kind.getFirstBucket(start, end, (double)maxTicks);
        IQuantity first = (IQuantity)firstBucket.getStart();
        IQuantity diff = (IQuantity)firstBucket.getExtent();
        AdHocQuantityTest.assertNearlySame("Spacing", expectedSpacing, diff);
        AdHocQuantityTest.assertNearlySame("Start", expectedAlignedStart, first);
    }

    private void assertTicks(ITypedQuantity<LinearUnit> expectedSpacing, Number expectedAlignedStart, Number start, Number end, IUnit unit, int maxTicks) throws Exception {
        this.assertTicks(expectedSpacing, unit.quantity(expectedAlignedStart), unit.quantity(start), unit.quantity(end), maxTicks);
    }

    private void assertTicks(Number expectedSpacing, Number expectedAlignedStart, LinearUnit expectedUnit, Number start, Number end, LinearUnit unit, int maxTicks) throws Exception {
        this.assertTicks((ITypedQuantity<LinearUnit>)expectedUnit.quantity(expectedSpacing), (IQuantity)expectedUnit.quantity(expectedAlignedStart), (IQuantity)unit.quantity(start), (IQuantity)unit.quantity(end), maxTicks);
    }

    private void assertTicks(Number expectedSpacing, Number expectedAlignedStart, Number start, Number end, LinearUnit unit, int maxTicks) throws Exception {
        this.assertTicks(expectedSpacing, expectedAlignedStart, unit, start, end, unit, maxTicks);
    }

    @Test
    public void testMemoryTicks() throws Exception {
        this.assertTicks(2, 2, this.kiB, 2675, 15000, this.B, 10);
        this.assertTicks(2, (Number)2, (Number)2.67, (Number)15, this.kiB, 10);
    }

    @Test
    public void testNumberTicks() throws Exception {
        this.assertTicks(0.5, (Number)1, (Number)1, (Number)5, this.one, 10);
        this.assertTicks(2, (Number)2, (Number)2.67, (Number)15, this.one, 10);
        this.assertTicks(2, (Number)2, (Number)2.67, (Number)22, this.one, 10);
        this.assertTicks(2, (Number)2, (Number)2.67, (Number)22.67, this.one, 10);
        this.assertTicks(2.5, (Number)2.5, (Number)2.67, (Number)22.68, this.one, 10);
        this.assertTicks(2.5, (Number)2.5, (Number)2.67, (Number)23, this.one, 10);
    }

    @Test
    public void testSecondsTicks() throws Exception {
        this.assertTicks(0.5, (Number)1, (Number)1, (Number)5, this.s, 10);
        this.assertTicks(2, (Number)2, (Number)2.67, (Number)15, this.s, 10);
        this.assertTicks(2, (Number)2, (Number)2.67, (Number)22, this.s, 10);
        this.assertTicks(2, (Number)2, (Number)2.67, (Number)22.67, this.s, 10);
        this.assertTicks(4, (Number)0, (Number)2.67, (Number)22.68, this.s, 10);
        this.assertTicks(4, (Number)0, (Number)2.67, (Number)23, this.s, 10);
    }

    @Test
    public void testMinutesTicks() throws Exception {
        this.assertTicks((ITypedQuantity<LinearUnit>)this.s.quantity(30L), (Number)1, (Number)1, (Number)5, (IUnit)this.min, 10);
        this.assertTicks(2, (Number)2, (Number)2.67, (Number)15, this.min, 10);
        this.assertTicks(2, (Number)2, (Number)2.67, (Number)22.67, this.min, 10);
        this.assertTicks(4, (Number)0, (Number)2.67, (Number)22.68, this.min, 10);
        this.assertTicks(4, (Number)0, (Number)2.67, (Number)23, this.min, 10);
    }

    @Test
    public void testHoursTicks() throws Exception {
        this.assertTicks((ITypedQuantity<LinearUnit>)this.min.quantity(30L), (Number)1, (Number)1, (Number)5, (IUnit)this.h, 10);
        this.assertTicks(2, (Number)2, (Number)2.67, (Number)15, this.h, 10);
        this.assertTicks(2, (Number)2, (Number)2.67, (Number)22.67, this.h, 10);
        this.assertTicks(4, (Number)0, (Number)2.67, (Number)22.68, this.h, 10);
        this.assertTicks(4, (Number)0, (Number)2.67, (Number)23, this.h, 10);
    }

    @Test
    public void testDaysTicks() throws Exception {
        this.assertTicks((ITypedQuantity<LinearUnit>)this.h.quantity(12L), (Number)1, (Number)1, (Number)5, (IUnit)this.d, 10);
        this.assertTicks(2, (Number)2, (Number)2.67, (Number)15, this.d, 10);
        this.assertTicks(2, (Number)2, (Number)2.67, (Number)22.67, this.d, 10);
        this.assertTicks(4, (Number)0, (Number)2.67, (Number)22.68, this.d, 10);
        this.assertTicks(4, (Number)0, (Number)2.67, (Number)23, this.d, 10);
    }

    @Test
    public void testWeeksTicks() throws Exception {
        this.assertTicks(4, 4, this.d, 1, 5, this.wk, 10);
        this.assertTicks(2, (Number)2, (Number)2.67, (Number)15, this.wk, 10);
        this.assertTicks(2, (Number)2, (Number)2.67, (Number)22.67, this.wk, 10);
        this.assertTicks(4, (Number)0, (Number)2.67, (Number)22.68, this.wk, 10);
        this.assertTicks(4, (Number)0, (Number)2.67, (Number)23, this.wk, 10);
    }

    @Test
    public void testYearsTicks() throws Exception {
        this.assertTicks(0.25, (Number)1, (Number)1, (Number)2.5, this.y, 10);
        this.assertTicks(0.5, (Number)1, (Number)1, (Number)5, this.y, 10);
        this.assertTicks(2, (Number)2, (Number)2.67, (Number)15, this.y, 10);
        this.assertTicks(2, (Number)2, (Number)2.67, (Number)22.67, this.y, 10);
        this.assertTicks(2.5, (Number)2.5, (Number)2.67, (Number)22.68, this.y, 10);
        this.assertTicks(2.5, (Number)2.5, (Number)2.67, (Number)23, this.y, 10);
    }
}

