/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer.api;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedFieldValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueBuilderImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Type;
import org.openjdk.jmc.flightrecorder.writer.api.TypedFieldValue;
import org.openjdk.jmc.flightrecorder.writer.api.TypedValue;
import org.openjdk.jmc.flightrecorder.writer.api.TypedValueBuilder;
import org.openjdk.jmc.flightrecorder.writer.api.Types;
import org.openjdk.jmc.flightrecorder.writer.util.NonZeroHashCode;

public final class Annotation {
    private static final String VALUE_KEY = "value";
    public static final String ANNOTATION_SUPER_TYPE_NAME = "java.lang.annotation.Annotation";
    private int hashCode = 0;
    private final Type type;
    private final Map<String, ? extends TypedFieldValue> attributes;
    private final List<Annotation> annotations = new ArrayList<Annotation>();

    public Annotation(Type type) {
        this(type, null);
    }

    public Annotation(Type type, String value) {
        if (!Annotation.isAnnotationType(type)) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.attributes = value != null ? this.singleValue(value) : Collections.emptyMap();
    }

    public Annotation(Type type, String value, Annotation ... annotations) {
        if (!Annotation.isAnnotationType(type)) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.attributes = value != null ? this.singleValue(value) : Collections.emptyMap();
        this.annotations.addAll(Arrays.asList(annotations));
    }

    public Annotation(Type type, Map<String, ? extends TypedFieldValue> attributes, Annotation ... annotations) {
        if (!Annotation.isAnnotationType(type)) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.attributes = attributes;
    }

    public Annotation(Type type, Consumer<TypedValueBuilder> builderCallback, Annotation ... annotations) {
        if (!Annotation.isAnnotationType(type)) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        TypedValueBuilderImpl builder = new TypedValueBuilderImpl((TypeImpl)type);
        if (builderCallback != null) {
            builderCallback.accept(builder);
        }
        this.attributes = builder.build();
    }

    public static boolean isAnnotationType(Type type) {
        return ANNOTATION_SUPER_TYPE_NAME.equals(type.getSupertype());
    }

    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    public Type getType() {
        return this.type;
    }

    public String getValue() {
        return this.getValue(String.class, VALUE_KEY);
    }

    public <T> T getValue(Class<T> valueType, String name) {
        TypedFieldValue fieldValue = this.attributes.get(name);
        if (fieldValue == null) {
            return null;
        }
        Object val = null;
        if (fieldValue.getField().isArray()) {
            TypedValue[] values = fieldValue.getValues();
            Object valArray = Array.newInstance(valueType.getComponentType(), values.length);
            for (int i = 0; i < values.length; ++i) {
                Array.set(valArray, i, values[i].getValue());
            }
            val = valArray;
        } else {
            TypedValue typedValue = fieldValue.getValue();
            Object object = val = typedValue != null ? typedValue.getValue() : null;
        }
        if (val != null && !valueType.isAssignableFrom(val.getClass())) {
            throw new IllegalArgumentException();
        }
        return (T)val;
    }

    public Map<String, ? extends TypedFieldValue> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Annotation that = (Annotation)o;
        return this.type.equals(that.type) && Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = NonZeroHashCode.hash(this.type, this.attributes);
        }
        return this.hashCode;
    }

    public String toString() {
        return "Annotation [type=" + this.type + ", attributes=" + this.attributes + "]";
    }

    private Map<String, ? extends TypedFieldValue> singleValue(String value) {
        TypeImpl targetType = (TypeImpl)this.type.getTypes().getType(Types.Builtin.STRING);
        TypedValueImpl typedValue = targetType.asValue(value);
        TypedFieldImpl typedField = new TypedFieldImpl(targetType, VALUE_KEY);
        return Collections.singletonMap(VALUE_KEY, new TypedFieldValueImpl(typedField, typedValue));
    }
}

