/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.flightrecorder.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.openjdk.jmc.flightrecorder.writer.Chunk;
import org.openjdk.jmc.flightrecorder.writer.ConstantPool;
import org.openjdk.jmc.flightrecorder.writer.ConstantPools;
import org.openjdk.jmc.flightrecorder.writer.LEB128Writer;
import org.openjdk.jmc.flightrecorder.writer.MetadataImpl;
import org.openjdk.jmc.flightrecorder.writer.TypeImpl;
import org.openjdk.jmc.flightrecorder.writer.TypedValueImpl;
import org.openjdk.jmc.flightrecorder.writer.TypesImpl;
import org.openjdk.jmc.flightrecorder.writer.api.Recording;
import org.openjdk.jmc.flightrecorder.writer.api.RecordingSettings;
import org.openjdk.jmc.flightrecorder.writer.api.TypeStructureBuilder;
import org.openjdk.jmc.flightrecorder.writer.api.TypedValue;
import org.openjdk.jmc.flightrecorder.writer.api.Types;

public final class RecordingImpl
extends Recording {
    private static final byte[] MAGIC = new byte[]{70, 76, 82, 0};
    private static final short MAJOR_VERSION = 2;
    private static final short MINOR_VERSION = 0;
    private static final long SIZE_OFFSET = 8L;
    private static final long CONSTANT_OFFSET_OFFSET = 16L;
    private static final long METADATA_OFFSET_OFFSET = 24L;
    private static final long DURATION_NANOS_OFFSET = 40L;
    private final Set<Chunk> activeChunks = new CopyOnWriteArraySet<Chunk>();
    private final LEB128Writer globalWriter = LEB128Writer.getInstance();
    private final InheritableThreadLocal<WeakReference<Chunk>> threadChunk = new InheritableThreadLocal<WeakReference<Chunk>>(){

        @Override
        protected WeakReference<Chunk> initialValue() {
            Chunk chunk = new Chunk();
            RecordingImpl.this.activeChunks.add(chunk);
            return new WeakReference<Chunk>(chunk);
        }
    };
    private final long startTicks;
    private final long startNanos;
    private final OutputStream outputStream;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final BlockingDeque<LEB128Writer> chunkDataQueue = new LinkedBlockingDeque<LEB128Writer>();
    private final ExecutorService chunkDataMergingService = Executors.newSingleThreadExecutor();
    private final ConstantPools constantPools = new ConstantPools();
    private final MetadataImpl metadata = new MetadataImpl(this.constantPools);
    private final TypesImpl types;

    public RecordingImpl(OutputStream output, RecordingSettings settings) {
        this.startTicks = settings.getStartTimestamp();
        this.startNanos = settings.getStartTimestamp();
        this.outputStream = output;
        this.types = new TypesImpl(this.metadata, settings.shouldInitializeJDKTypes());
        this.writeFileHeader();
        this.chunkDataMergingService.submit(() -> {
            try {
                while (!this.chunkDataMergingService.isShutdown()) {
                    this.processChunkDataQueue(500L, TimeUnit.MILLISECONDS);
                }
                this.processChunkDataQueue(1L, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        });
    }

    private void processChunkDataQueue(long pollTimeout, TimeUnit timeUnit) throws InterruptedException {
        LEB128Writer writer = this.chunkDataQueue.poll(pollTimeout, timeUnit);
        if (writer != null) {
            ArrayList<LEB128Writer> writers = new ArrayList<LEB128Writer>();
            writers.add(writer);
            this.chunkDataQueue.drainTo(writers);
            for (LEB128Writer w : writers) {
                this.globalWriter.writeBytes(w.export());
            }
        }
    }

    @Override
    public RecordingImpl rotateChunk() {
        Chunk chunk = this.getChunk();
        this.activeChunks.remove(chunk);
        this.threadChunk.remove();
        chunk.finish(writer -> {
            try {
                this.chunkDataQueue.put((LEB128Writer)writer);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
        });
        return this;
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                for (Chunk chunk : this.activeChunks) {
                    chunk.finish(writer -> {
                        try {
                            this.chunkDataQueue.put((LEB128Writer)writer);
                        }
                        catch (InterruptedException ignored) {
                            Thread.currentThread().interrupt();
                        }
                    });
                }
                this.activeChunks.clear();
                this.chunkDataMergingService.shutdown();
                boolean flushed = false;
                try {
                    flushed = this.chunkDataMergingService.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (!flushed) {
                    throw new RuntimeException("Unable to flush dangling JFR chunks");
                }
                this.finalizeRecording();
                this.outputStream.write(this.globalWriter.export());
            }
            finally {
                this.outputStream.close();
            }
        }
    }

    private Chunk getChunk() {
        if (this.closed.get()) {
            throw new IllegalStateException("Recording is already closed. Can not add more data.");
        }
        return (Chunk)((WeakReference)this.threadChunk.get()).get();
    }

    @Override
    public RecordingImpl writeEvent(TypedValue event) {
        this.getChunk().writeEvent((TypedValueImpl)event);
        return this;
    }

    @Override
    public TypeImpl registerEventType(String name) {
        return this.registerEventType(name, builder -> {});
    }

    @Override
    public TypeImpl registerEventType(String name, Consumer<TypeStructureBuilder> builderCallback) {
        if (name == null || builderCallback == null) {
            throw new IllegalArgumentException();
        }
        return this.registerType(name, "jdk.jfr.Event", builder -> {
            builder.addField("stackTrace", Types.JDK.STACK_TRACE).addField("eventThread", Types.JDK.THREAD).addField("startTime", Types.Builtin.LONG, field -> field.addAnnotation((Types.Predefined)Types.JDK.ANNOTATION_TIMESTAMP, "TICKS"));
            builderCallback.accept((TypeStructureBuilder)builder);
        });
    }

    @Override
    public TypeImpl registerAnnotationType(String name) {
        return this.registerAnnotationType(name, builder -> {});
    }

    @Override
    public TypeImpl registerAnnotationType(String name, Consumer<TypeStructureBuilder> builderCallback) {
        return this.registerType(name, "java.lang.annotation.Annotation", (Consumer)builderCallback);
    }

    @Override
    public TypeImpl registerType(String name, Consumer<TypeStructureBuilder> builderCallback) {
        return this.registerType(name, (String)null, (Consumer)builderCallback);
    }

    @Override
    public TypeImpl registerType(String name, String supertype, Consumer<TypeStructureBuilder> builderCallback) {
        if (builderCallback == null || name == null) {
            throw new IllegalArgumentException();
        }
        return this.types.getOrAdd(name, supertype, (Consumer)builderCallback);
    }

    @Override
    public TypeImpl getType(Types.JDK type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return this.getType(type.getTypeName());
    }

    @Override
    public TypeImpl getType(String typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException();
        }
        TypeImpl type = this.types.getType(typeName);
        if (type == null) {
            throw new IllegalArgumentException();
        }
        return type;
    }

    @Override
    public TypesImpl getTypes() {
        return this.types;
    }

    private void writeFileHeader() {
        this.globalWriter.writeBytes(MAGIC).writeShortRaw((short)2).writeShortRaw((short)0).writeLongRaw(0L).writeLongRaw(0L).writeLongRaw(0L).writeLongRaw(this.startNanos).writeLongRaw(0L).writeLongRaw(this.startTicks).writeLongRaw(1000000000L).writeIntRaw(1);
    }

    private void finalizeRecording() {
        long duration = System.nanoTime() - this.startTicks;
        this.types.resolveAll();
        long checkpointOffset = this.globalWriter.position();
        this.writeCheckpointEvent();
        long metadataOffset = this.globalWriter.position();
        this.writeMetadataEvent(duration);
        this.globalWriter.writeLongRaw(40L, duration);
        this.globalWriter.writeLongRaw(8L, this.globalWriter.position());
        this.globalWriter.writeLongRaw(16L, checkpointOffset);
        this.globalWriter.writeLongRaw(24L, metadataOffset);
    }

    private void writeCheckpointEvent() {
        LEB128Writer cpWriter = LEB128Writer.getInstance();
        cpWriter.writeLong(1L).writeLong(this.startNanos).writeLong(System.nanoTime() - this.startTicks).writeLong(0L).writeInt(1).writeInt(this.metadata.getConstantPools().size());
        for (ConstantPool cp : this.metadata.getConstantPools()) {
            cp.writeTo(cpWriter);
        }
        this.globalWriter.writeInt(cpWriter.length());
        this.globalWriter.writeBytes(cpWriter.export());
    }

    private void writeMetadataEvent(long duration) {
        this.metadata.writeMetaEvent(this.globalWriter, this.startTicks, duration);
    }
}

