/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.graph.internal.maven30;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.maven.shared.dependency.graph.internal.maven30.ConflictResolver;
import org.apache.maven.shared.dependency.graph.internal.maven30.JavaScopeSelector;
import org.sonatype.aether.RepositoryException;

public class VerboseJavaScopeSelector
extends ConflictResolver.ScopeSelector {
    public static final String REDUCED_SCOPE = "REDUCED_SCOPE";
    private final ConflictResolver.ScopeSelector scopeSelector = new JavaScopeSelector();

    @Override
    public void selectScope(ConflictResolver.ConflictContext context) throws RepositoryException {
        this.scopeSelector.selectScope(context);
        context.getItems().stream().flatMap(i -> i.getScopes().stream()).distinct().max(new ScopeComparator()).filter(s -> s != context.getScope()).ifPresent(s -> context.getWinner().getNode().setData((Object)REDUCED_SCOPE, s));
    }

    static class ScopeComparator
    implements Comparator<String> {
        List<String> orderedScopes = Arrays.asList("compile", "runtime", "provided", "test");

        ScopeComparator() {
        }

        @Override
        public int compare(String lhs, String rhs) {
            return this.orderedScopes.indexOf(rhs) - this.orderedScopes.indexOf(lhs);
        }
    }
}

