/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public final class ModularClasspath {
    private final File moduleDescriptor;
    private final List<String> modulePath;
    private final Collection<String> packages;
    private final File patchFile;

    public ModularClasspath(@Nonnull File moduleDescriptor, @Nonnull List<String> modulePath, @Nonnull Collection<String> packages, @Nonnull File patchFile) {
        this.moduleDescriptor = moduleDescriptor;
        this.modulePath = modulePath;
        this.packages = packages;
        this.patchFile = patchFile;
    }

    @Nonnull
    public File getModuleDescriptor() {
        return this.moduleDescriptor;
    }

    @Nonnull
    public List<String> getModulePath() {
        return Collections.unmodifiableList(this.modulePath);
    }

    @Nonnull
    public Collection<String> getPackages() {
        return Collections.unmodifiableCollection(this.packages);
    }

    @Nonnull
    public File getPatchFile() {
        return this.patchFile;
    }
}

