/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.List;
import org.apache.commons.lang3.SystemUtils;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;

public class RequireJavaVendor
extends AbstractNonCacheableEnforcerRule {
    private List<String> includes;
    private List<String> excludes;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        if (this.excludes != null && this.excludes.contains(SystemUtils.JAVA_VENDOR)) {
            String message = this.getMessage();
            if (message == null) {
                message = String.format("%s is an excluded Required Java Vendor", SystemUtils.JAVA_VENDOR);
            }
            throw new EnforcerRuleException(message);
        }
        if (this.includes != null && !this.includes.contains(SystemUtils.JAVA_VENDOR)) {
            String message = this.getMessage();
            if (message == null) {
                message = String.format("%s is not an included Required Java Vendor", SystemUtils.JAVA_VENDOR);
            }
            throw new EnforcerRuleException(message);
        }
    }

    public void setExcludes(List<String> theExcludes) {
        this.excludes = theExcludes;
    }

    public void setIncludes(List<String> theIncludes) {
        this.includes = theIncludes;
    }
}

