/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.util.internal;

import java.io.File;
import java.net.URI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.core.ProvisionException;

public class RepositoryFactoryTools {
    public static File asFile(URI location) {
        if ("file".equals(location.getScheme())) {
            return new File(location);
        }
        return null;
    }

    public static void verifyModifiableNotRequested(int flags, String repositoryType) throws ProvisionException {
        if ((flags & 1) != 0) {
            Status errorStatus = new Status(4, "org.eclipse.tycho.p2.maven.repository", 1004, "Cannot create writable repositories of type " + repositoryType, null);
            throw new ProvisionException((IStatus)errorStatus);
        }
    }

    public static ProvisionException unsupportedCreation(String repositoryType) {
        String message = "Cannot create repositories of type " + repositoryType;
        return new ProvisionException((IStatus)RepositoryFactoryTools.newUnsupportedCreationStatus(message));
    }

    public static ProvisionException unsupportedCreation(Class<?> factoryClass) {
        String message = "The factory " + factoryClass.getName() + " cannot create repositories";
        return new ProvisionException((IStatus)RepositoryFactoryTools.newUnsupportedCreationStatus(message));
    }

    private static Status newUnsupportedCreationStatus(String message) {
        int errorCode = 0;
        return new Status(4, "org.eclipse.tycho.p2.maven.repository", errorCode, message, null);
    }

    public static ProvisionException invalidCreationLocation(String repositoryType, URI location) {
        String message = "Cannot create repositories of type " + repositoryType + " at location " + location;
        int errorCode = 1006;
        return new ProvisionException((IStatus)new Status(4, "org.eclipse.tycho.p2.maven.repository", errorCode, message, null));
    }
}

