/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.local;

import java.io.File;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.tycho.core.shared.MavenLogger;
import org.eclipse.tycho.core.shared.MultiLineLogger;
import org.eclipse.tycho.repository.local.LocalArtifactRepository;
import org.eclipse.tycho.repository.local.PackedFormatMirroringArtifactProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactFileProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.formats.ArtifactTransferPolicy;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.ArtifactSinkException;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.IArtifactSink;
import org.eclipse.tycho.repository.p2base.artifact.provider.streaming.IRawArtifactSink;
import org.eclipse.tycho.repository.util.DuplicateFilteringLoggingProgressMonitor;
import org.eclipse.tycho.repository.util.LoggingProgressMonitor;
import org.eclipse.tycho.repository.util.StatusTool;

public class MirroringArtifactProvider
implements IRawArtifactFileProvider {
    protected final MavenLogger logger;
    protected final MavenLogger splittingLogger;
    protected final IRawArtifactProvider remoteProviders;
    protected final LocalArtifactRepository localArtifactRepository;
    protected final IProgressMonitor monitor;

    public static MirroringArtifactProvider createInstance(LocalArtifactRepository localArtifactRepository, IRawArtifactProvider remoteProviders, boolean mirrorPacked, MavenLogger logger) {
        if (!mirrorPacked) {
            return new MirroringArtifactProvider(localArtifactRepository, remoteProviders, logger);
        }
        return new PackedFormatMirroringArtifactProvider(localArtifactRepository, remoteProviders, logger);
    }

    MirroringArtifactProvider(LocalArtifactRepository localArtifactRepository, IRawArtifactProvider remoteProviders, MavenLogger logger) {
        this.remoteProviders = remoteProviders;
        this.localArtifactRepository = localArtifactRepository;
        this.logger = logger;
        this.splittingLogger = new MultiLineLogger(logger);
        this.monitor = new LoggingProgressMonitor(logger);
    }

    @Override
    public final boolean contains(IArtifactKey key) {
        if (this.localArtifactRepository.contains(key)) {
            return true;
        }
        return this.remoteProviders.contains(key);
    }

    public final IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
        IQueryable[] sources = new IQueryable[]{this.localArtifactRepository, this.remoteProviders};
        return new CompoundQueryable(sources).query(query, MirroringArtifactProvider.nonNull(monitor));
    }

    @Override
    public final File getArtifactFile(IArtifactKey key) throws MirroringFailedException {
        if (this.makeLocallyAvailable(key)) {
            return this.localArtifactRepository.getArtifactFile(key);
        }
        return null;
    }

    @Override
    public final File getArtifactFile(IArtifactDescriptor descriptor) throws MirroringFailedException {
        if (this.makeLocallyAvailable(descriptor.getArtifactKey())) {
            return this.localArtifactRepository.getArtifactFile(descriptor);
        }
        return null;
    }

    @Override
    public final IStatus getArtifact(IArtifactSink sink, IProgressMonitor monitor) throws ArtifactSinkException, MirroringFailedException {
        IArtifactKey requestedKey = sink.getArtifactToBeWritten();
        if (this.makeLocallyAvailable(requestedKey)) {
            return this.localArtifactRepository.getArtifact(sink, monitor);
        }
        return MirroringArtifactProvider.artifactNotFoundStatus(requestedKey);
    }

    @Override
    public final IStatus getRawArtifact(IRawArtifactSink sink, IProgressMonitor monitor) throws ArtifactSinkException, MirroringFailedException {
        IArtifactKey requestedKey = sink.getArtifactToBeWritten();
        if (this.makeLocallyAvailable(requestedKey)) {
            return this.localArtifactRepository.getRawArtifact(sink, monitor);
        }
        return MirroringArtifactProvider.artifactNotFoundStatus(requestedKey);
    }

    @Override
    public final IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) throws MirroringFailedException {
        if (this.makeLocallyAvailable(key)) {
            return this.localArtifactRepository.getArtifactDescriptors(key);
        }
        return new IArtifactDescriptor[0];
    }

    @Override
    public final boolean contains(IArtifactDescriptor descriptor) throws MirroringFailedException {
        if (this.makeLocallyAvailable(descriptor.getArtifactKey())) {
            return this.localArtifactRepository.contains(descriptor);
        }
        return false;
    }

    private boolean makeLocallyAvailable(IArtifactKey key) throws MirroringFailedException {
        try {
            boolean isAvailable = this.makeOneFormatLocallyAvailable(key);
            if (isAvailable) {
                this.ensureArtifactIsPresentInCanonicalFormat(key);
            }
            return isAvailable;
        }
        catch (ProvisionException e) {
            throw new MirroringFailedException("Error while mirroring artifact " + key + " to the local Maven repository" + e.getMessage(), e);
        }
        catch (ArtifactSinkException e) {
            throw new MirroringFailedException("Error while mirroring artifact " + key + " to the local Maven repository" + e.getMessage(), e);
        }
    }

    protected boolean makeOneFormatLocallyAvailable(IArtifactKey key) throws MirroringFailedException, ProvisionException, ArtifactSinkException {
        if (this.localArtifactRepository.contains(key)) {
            return true;
        }
        if (this.remoteProviders.contains(key)) {
            this.downloadArtifact(key);
            return true;
        }
        return false;
    }

    protected final void downloadArtifact(IArtifactKey key) throws MirroringFailedException, ProvisionException, ArtifactSinkException {
        IStatus transferStatus = this.downloadMostSpecificNeededFormatOfArtifact(key);
        if (transferStatus.matches(12)) {
            this.splittingLogger.error(StatusTool.toLogMessage(transferStatus));
            throw new MirroringFailedException("Could not mirror artifact " + key + " into the local Maven repository." + "See log output for details.", StatusTool.findException(transferStatus));
        }
        if (transferStatus.matches(2)) {
            this.splittingLogger.warn(StatusTool.toLogMessage(transferStatus));
        }
    }

    protected IStatus downloadMostSpecificNeededFormatOfArtifact(IArtifactKey key) throws ProvisionException, ArtifactSinkException {
        return this.downloadCanonicalArtifact(key);
    }

    protected final IStatus downloadCanonicalArtifact(IArtifactKey key) throws ProvisionException, ArtifactSinkException {
        IArtifactSink localSink = this.localArtifactRepository.newAddingArtifactSink(key);
        return this.remoteProviders.getArtifact(localSink, this.monitorForDownload());
    }

    private void ensureArtifactIsPresentInCanonicalFormat(IArtifactKey key) throws ProvisionException, ArtifactSinkException {
        if (MirroringArtifactProvider.findCanonicalDescriptor(this.localArtifactRepository.getArtifactDescriptors(key)) == null) {
            this.createCanonicalArtifactFromLocalPackedArtifact(key);
        }
    }

    private void createCanonicalArtifactFromLocalPackedArtifact(IArtifactKey key) throws ProvisionException, ArtifactSinkException {
        this.logger.info("Unpacking " + key.getId() + "_" + key.getVersion() + "...");
        IArtifactSink sink = this.localArtifactRepository.newAddingArtifactSink(key);
        this.localArtifactRepository.getArtifact(sink, this.monitor);
    }

    static IArtifactDescriptor findPackedDescriptor(IArtifactDescriptor[] descriptors) {
        IArtifactDescriptor[] iArtifactDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactDescriptor descriptor = iArtifactDescriptorArray[n2];
            if (ArtifactTransferPolicy.isPack200Format(descriptor)) {
                return descriptor;
            }
            ++n2;
        }
        return null;
    }

    static IArtifactDescriptor findCanonicalDescriptor(IArtifactDescriptor[] descriptors) {
        IArtifactDescriptor[] iArtifactDescriptorArray = descriptors;
        int n = descriptors.length;
        int n2 = 0;
        while (n2 < n) {
            IArtifactDescriptor descriptor = iArtifactDescriptorArray[n2];
            if (ArtifactTransferPolicy.isCanonicalFormat(descriptor)) {
                return descriptor;
            }
            ++n2;
        }
        return null;
    }

    private static IStatus artifactNotFoundStatus(IArtifactKey key) {
        return new Status(4, "org.eclipse.tycho.p2.maven.repository", 1200, "Artifact " + key + " is neither available in the local Maven repository nor in the configured remote repositories", null);
    }

    final IProgressMonitor monitorForDownload() {
        return new DuplicateFilteringLoggingProgressMonitor(this.logger);
    }

    private static IProgressMonitor nonNull(IProgressMonitor monitor) {
        if (monitor == null) {
            return new NullProgressMonitor();
        }
        return monitor;
    }

    public static class MirroringFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        MirroringFailedException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

