/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.core.shared;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.tycho.core.shared.BuildProperties;

public class BuildPropertiesImpl
implements BuildProperties {
    private String javacSource;
    private String javacTarget;
    private String jreCompilationProfile;
    private String forceContextQualifier;
    private boolean rootFilesUseDefaultExcludes;
    private List<String> binIncludes;
    private List<String> binExcludes;
    private List<String> sourceIncludes;
    private List<String> sourceExcludes;
    private List<String> jarsExtraClasspath;
    private List<String> jarsCompileOrder;
    private Map<String, List<String>> jarToSourceFolderMap;
    private Map<String, List<String>> jarToExtraClasspathMap;
    private Map<String, String> jarToJavacDefaultEncodingMap;
    private Map<String, String> jarToOutputFolderMap;
    private Map<String, List<String>> jarToExcludeFileMap;
    private Map<String, String> jarToManifestMap;
    private Map<String, String> rootEntries;
    private long timestamp;
    private String additionalBundles;

    public BuildPropertiesImpl(Properties properties) {
        this(properties, System.currentTimeMillis());
    }

    public BuildPropertiesImpl(Properties properties, long timestamp) {
        this.timestamp = timestamp;
        this.additionalBundles = BuildPropertiesImpl.safeTrimValue("additional.bundles", properties);
        this.javacSource = BuildPropertiesImpl.safeTrimValue("javacSource", properties);
        this.javacTarget = BuildPropertiesImpl.safeTrimValue("javacTarget", properties);
        this.forceContextQualifier = BuildPropertiesImpl.safeTrimValue("forceContextQualifier", properties);
        this.jreCompilationProfile = BuildPropertiesImpl.safeTrimValue("jre.compilation.profile", properties);
        this.rootFilesUseDefaultExcludes = Boolean.parseBoolean(properties.getProperty("rootFiles.useDefaultExcludes", "true"));
        this.sourceIncludes = BuildPropertiesImpl.splitAndTrimCommaSeparated(properties.getProperty("src.includes"));
        this.sourceExcludes = BuildPropertiesImpl.splitAndTrimCommaSeparated(properties.getProperty("src.excludes"));
        this.binIncludes = BuildPropertiesImpl.splitAndTrimCommaSeparated(properties.getProperty("bin.includes"));
        this.binExcludes = BuildPropertiesImpl.splitAndTrimCommaSeparated(properties.getProperty("bin.excludes"));
        this.jarsExtraClasspath = BuildPropertiesImpl.splitAndTrimCommaSeparated(properties.getProperty("jars.extra.classpath"));
        this.jarsCompileOrder = BuildPropertiesImpl.splitAndTrimCommaSeparated(properties.getProperty("jars.compile.order"));
        LinkedHashMap<String, List<String>> jarTosourceFolderTmp = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, List<String>> jarToExtraClasspathTmp = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, String> jarToJavacDefaultEncodingTmp = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> jarToOutputFolderMapTmp = new LinkedHashMap<String, String>();
        LinkedHashMap<String, List<String>> jarToExcludeFileMapTmp = new LinkedHashMap<String, List<String>>();
        LinkedHashMap<String, String> jarToManifestMapTmp = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> rootEntriesTmp = new LinkedHashMap<String, String>();
        ArrayList<String> sortedKeys = new ArrayList<String>(properties.stringPropertyNames());
        Collections.sort(sortedKeys);
        for (String key : sortedKeys) {
            String jarName;
            String trimmedKey = key.trim();
            String value = properties.getProperty(key);
            if (trimmedKey.startsWith("source.")) {
                jarName = trimmedKey.substring("source.".length());
                jarTosourceFolderTmp.put(jarName, BuildPropertiesImpl.splitAndTrimCommaSeparated(value));
                continue;
            }
            if (trimmedKey.startsWith("extra.")) {
                jarName = trimmedKey.substring("extra.".length());
                jarToExtraClasspathTmp.put(jarName, BuildPropertiesImpl.splitAndTrimCommaSeparated(value));
                continue;
            }
            if (trimmedKey.startsWith("javacDefaultEncoding.")) {
                jarName = trimmedKey.substring("javacDefaultEncoding.".length());
                jarToJavacDefaultEncodingTmp.put(jarName, value);
                continue;
            }
            if (trimmedKey.startsWith("output.")) {
                jarName = trimmedKey.substring("output.".length());
                jarToOutputFolderMapTmp.put(jarName, value);
                continue;
            }
            if (trimmedKey.startsWith("exclude.")) {
                jarName = trimmedKey.substring("exclude.".length());
                jarToExcludeFileMapTmp.put(jarName, BuildPropertiesImpl.splitAndTrimCommaSeparated(value));
                continue;
            }
            if (trimmedKey.startsWith("manifest.")) {
                jarName = trimmedKey.substring("manifest.".length());
                jarToManifestMapTmp.put(jarName, value);
                continue;
            }
            if (!trimmedKey.startsWith("root.") && !trimmedKey.equals("root")) continue;
            rootEntriesTmp.put(trimmedKey, value);
        }
        this.jarToSourceFolderMap = Collections.unmodifiableMap(jarTosourceFolderTmp);
        this.jarToExtraClasspathMap = Collections.unmodifiableMap(jarToExtraClasspathTmp);
        this.jarToJavacDefaultEncodingMap = Collections.unmodifiableMap(jarToJavacDefaultEncodingTmp);
        this.jarToOutputFolderMap = Collections.unmodifiableMap(jarToOutputFolderMapTmp);
        this.jarToExcludeFileMap = Collections.unmodifiableMap(jarToExcludeFileMapTmp);
        this.jarToManifestMap = Collections.unmodifiableMap(jarToManifestMapTmp);
        this.rootEntries = Collections.unmodifiableMap(rootEntriesTmp);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    private static String safeTrimValue(String key, Properties buildProperties) {
        String value = buildProperties.getProperty(key);
        if (value != null) {
            value = value.trim();
        }
        return value;
    }

    private static List<String> splitAndTrimCommaSeparated(String rawValue) {
        ArrayList<String> result = new ArrayList<String>();
        if (rawValue != null) {
            String[] stringArray = rawValue.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String element = stringArray[n2];
                result.add(element.trim());
                ++n2;
            }
        }
        if (result.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<String> getBinIncludes() {
        return this.binIncludes;
    }

    @Override
    public List<String> getBinExcludes() {
        return this.binExcludes;
    }

    @Override
    public List<String> getSourceIncludes() {
        return this.sourceIncludes;
    }

    @Override
    public List<String> getSourceExcludes() {
        return this.sourceExcludes;
    }

    @Override
    public Map<String, List<String>> getJarToSourceFolderMap() {
        return this.jarToSourceFolderMap;
    }

    @Override
    public List<String> getJarsExtraClasspath() {
        return this.jarsExtraClasspath;
    }

    @Override
    public String getJavacSource() {
        return this.javacSource;
    }

    @Override
    public String getJavacTarget() {
        return this.javacTarget;
    }

    @Override
    public List<String> getJarsCompileOrder() {
        return this.jarsCompileOrder;
    }

    @Override
    public Map<String, List<String>> getJarToExtraClasspathMap() {
        return this.jarToExtraClasspathMap;
    }

    @Override
    public Map<String, String> getJarToJavacDefaultEncodingMap() {
        return this.jarToJavacDefaultEncodingMap;
    }

    @Override
    public Map<String, String> getJarToOutputFolderMap() {
        return this.jarToOutputFolderMap;
    }

    @Override
    public Map<String, List<String>> getJarToExcludeFileMap() {
        return this.jarToExcludeFileMap;
    }

    @Override
    public Map<String, String> getJarToManifestMap() {
        return this.jarToManifestMap;
    }

    @Override
    public String getJreCompilationProfile() {
        return this.jreCompilationProfile;
    }

    @Override
    public String getForceContextQualifier() {
        return this.forceContextQualifier;
    }

    @Override
    public boolean isRootFilesUseDefaultExcludes() {
        return this.rootFilesUseDefaultExcludes;
    }

    @Override
    public Map<String, String> getRootEntries() {
        return this.rootEntries;
    }

    @Override
    public Collection<String> getAdditionalBundles() {
        if (this.additionalBundles != null && !this.additionalBundles.isBlank()) {
            return Arrays.stream(this.additionalBundles.split(",")).map(String::strip).filter(Predicate.not(String::isBlank)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

