/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.repository.p2base.artifact.repository;

import java.io.File;
import java.net.URI;
import java.util.List;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.tycho.repository.p2base.artifact.provider.IRawArtifactFileProvider;
import org.eclipse.tycho.repository.p2base.artifact.provider.formats.ArtifactTransferPolicy;
import org.eclipse.tycho.repository.p2base.artifact.repository.RepositoryArtifactProvider;

public class FileRepositoryArtifactProvider
extends RepositoryArtifactProvider
implements IRawArtifactFileProvider {
    public FileRepositoryArtifactProvider(List<IFileArtifactRepository> repositories, ArtifactTransferPolicy transferPolicy) {
        super(repositories, transferPolicy);
    }

    public FileRepositoryArtifactProvider(List<URI> artifactRepositories, ArtifactTransferPolicy transferPolicy, IProvisioningAgent agent) {
        super(artifactRepositories, transferPolicy, agent);
    }

    FileRepositoryArtifactProvider(RepositoryArtifactProvider.RepositoryLoader repositoryLoader, ArtifactTransferPolicy transferPolicy) {
        super(repositoryLoader, transferPolicy);
    }

    @Override
    protected void repositoriesLoaded() {
        for (IArtifactRepository repository : this.repositories) {
            if (repository instanceof IFileArtifactRepository) continue;
            throw new IllegalArgumentException("Repository loaded from \"" + repository.getLocation() + "\" is not a file system based artifact repository.");
        }
    }

    @Override
    public File getArtifactFile(IArtifactKey key) {
        this.init();
        for (IArtifactRepository repository : this.repositories) {
            if (!repository.contains(key)) continue;
            return ((IFileArtifactRepository)repository).getArtifactFile(key);
        }
        return null;
    }

    @Override
    public File getArtifactFile(IArtifactDescriptor descriptor) {
        this.init();
        for (IArtifactRepository repository : this.repositories) {
            if (!repository.contains(descriptor)) continue;
            return ((IFileArtifactRepository)repository).getArtifactFile(descriptor);
        }
        return null;
    }
}

